/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil2.msgs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import org.jboss.mq.il.uil2.msgs.BaseMsg;

public class CreateDestMsg
extends BaseMsg {
    private String name;
    private Destination dest;

    public CreateDestMsg(boolean isQueue) {
        this(null, isQueue);
    }

    public CreateDestMsg(String name, boolean isQueue) {
        super(isQueue ? 6 : 7);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Queue getQueue() {
        return (Queue)this.dest;
    }

    public Topic getTopic() {
        return (Topic)this.dest;
    }

    public void setDest(Destination dest) {
        this.dest = dest;
    }

    public void write(ObjectOutputStream out) throws IOException {
        super.write(out);
        out.writeObject(this.name);
        int hasDest = this.dest != null ? 1 : 0;
        out.writeByte(hasDest);
        if (hasDest == 1) {
            out.writeObject(this.dest);
        }
    }

    public void read(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.read(in);
        this.name = (String)in.readObject();
        byte hasDest = in.readByte();
        if (hasDest == 1) {
            this.dest = (Destination)in.readObject();
        }
    }
}

