/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.metadata;

import java.beans.IntrospectionException;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.jboss.dom4j.Attribute;
import org.jboss.dom4j.Document;
import org.jboss.dom4j.DocumentException;
import org.jboss.dom4j.DocumentFactory;
import org.jboss.dom4j.io.DOMWriter;
import org.jboss.logging.Logger;
import org.jboss.mx.metadata.AbstractBuilder;
import org.jboss.mx.modelmbean.XMBeanConstants;
import org.jboss.mx.util.JBossNotCompliantMBeanException;
import org.jboss.util.Classes;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.util.propertyeditor.PropertyEditors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class JBossXMBean10
extends AbstractBuilder
implements XMBeanConstants {
    private static Logger log = Logger.getLogger(JBossXMBean10.class);
    private org.jboss.dom4j.Element element;
    private String mmbClassName = null;
    private String resourceClassName = null;

    public JBossXMBean10(String mmbClassName, String resourceClassName, org.jboss.dom4j.Element element, Map properties) {
        this.mmbClassName = mmbClassName;
        this.resourceClassName = resourceClassName;
        this.element = element;
        this.setProperties(properties);
    }

    public MBeanInfo build() throws NotCompliantMBeanException {
        try {
            if (this.element == null) {
                throw new JBossNotCompliantMBeanException("No xml configuration supplied!");
            }
            String description = this.element.elementTextTrim("description");
            if (this.resourceClassName == null) {
                this.resourceClassName = this.element.elementTextTrim("class");
            }
            List constructors = this.element.elements("constructor");
            List operations = this.element.elements("operation");
            List attributes = this.element.elements("attribute");
            List notifications = this.element.elements("notification");
            Descriptor descr = this.getDescriptor(this.element, this.mmbClassName, "mbean");
            ModelMBeanInfo info = this.buildMBeanMetaData(description, constructors, operations, attributes, notifications, descr);
            return (MBeanInfo)((Object)info);
        }
        catch (Throwable t) {
            throw new JBossNotCompliantMBeanException("Error parsing the XML file: ", t);
        }
    }

    protected Descriptor getDescriptor(org.jboss.dom4j.Element parent, String infoName, String type) throws NotCompliantMBeanException {
        DescriptorSupport descr = new DescriptorSupport();
        descr.setField("name", infoName);
        descr.setField("displayName", infoName);
        descr.setField("descriptorType", type);
        org.jboss.dom4j.Element descriptors = parent.element("descriptors");
        if (descriptors == null) {
            return descr;
        }
        Iterator i = descriptors.elementIterator();
        while (i.hasNext()) {
            String value;
            org.jboss.dom4j.Element descriptor = (org.jboss.dom4j.Element)i.next();
            String name = descriptor.getName();
            if (name.equals("persistence")) {
                String persistPolicy = descriptor.attributeValue("persistPolicy");
                String persistPeriod = descriptor.attributeValue("persistPeriod");
                String persistLocation = descriptor.attributeValue("persistLocation");
                String persistName = descriptor.attributeValue("persistName");
                if (persistPolicy != null) {
                    this.validate(persistPolicy, PERSIST_POLICIES);
                    descr.setField("persistPolicy", persistPolicy);
                }
                if (persistPeriod != null) {
                    descr.setField("persistPeriod", persistPeriod);
                }
                if (persistLocation != null) {
                    descr.setField("persistLocation", persistLocation);
                }
                if (persistName == null) continue;
                descr.setField("persistName", persistName);
                continue;
            }
            if (name.equals("currencyTimeLimit")) {
                descr.setField("currencyTimeLimit", descriptor.attributeValue("value"));
                continue;
            }
            if (name.equals("default")) {
                value = descriptor.attributeValue("value");
                descr.setField("default", value);
                continue;
            }
            if (name.equals("display-name")) {
                value = descriptor.attributeValue("value");
                descr.setField("displayName", value);
                continue;
            }
            if (name.equals("value")) {
                value = descriptor.attributeValue("value");
                descr.setField("value", value);
                continue;
            }
            if (name.equals("persistence-manager")) {
                descr.setField("persistence-manager", descriptor.attributeValue("value"));
                continue;
            }
            if (name.equals("descriptor")) {
                descr.setField(descriptor.attributeValue("name"), descriptor.attributeValue("value"));
                continue;
            }
            if (name.equals("injection")) {
                descr.setField(descriptor.attributeValue("id"), descriptor.attributeValue("setMethod"));
                continue;
            }
            if (!name.equals("interceptors")) continue;
            Descriptor[] interceptorDescriptors = this.buildInterceptors(descriptor);
            descr.setField("interceptors", interceptorDescriptors);
        }
        return descr;
    }

    private void validate(String value, String[] valid) throws NotCompliantMBeanException {
        for (int i = 0; i < valid.length; ++i) {
            if (!valid[i].equalsIgnoreCase(value)) continue;
            return;
        }
        throw new JBossNotCompliantMBeanException("Unknown descriptor value: " + value);
    }

    protected ModelMBeanInfo buildMBeanMetaData(String description, List constructors, List operations, List attributes, List notifications, Descriptor descr) throws NotCompliantMBeanException {
        ModelMBeanOperationInfo[] operInfo = this.buildOperationInfo(operations);
        ModelMBeanAttributeInfo[] attrInfo = this.buildAttributeInfo(attributes);
        ModelMBeanConstructorInfo[] constrInfo = this.buildConstructorInfo(constructors);
        ModelMBeanNotificationInfo[] notifInfo = this.buildNotificationInfo(notifications);
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(this.mmbClassName, description, attrInfo, constrInfo, operInfo, notifInfo, descr);
        return info;
    }

    protected ModelMBeanConstructorInfo[] buildConstructorInfo(List constructors) throws NotCompliantMBeanException {
        ArrayList<ModelMBeanConstructorInfo> infos = new ArrayList<ModelMBeanConstructorInfo>();
        Iterator it = constructors.iterator();
        while (it.hasNext()) {
            org.jboss.dom4j.Element constr = (org.jboss.dom4j.Element)it.next();
            String name = constr.elementTextTrim("name");
            String description = constr.elementTextTrim("description");
            List params = constr.elements("parameter");
            MBeanParameterInfo[] paramInfo = this.buildParameterInfo(params);
            Descriptor descr = this.getDescriptor(constr, name, "operation");
            descr.setField("role", "constructor");
            ModelMBeanConstructorInfo info = new ModelMBeanConstructorInfo(name, description, paramInfo, descr);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanConstructorInfo[0]);
    }

    protected ModelMBeanOperationInfo[] buildOperationInfo(List operations) throws NotCompliantMBeanException {
        ArrayList<ModelMBeanOperationInfo> infos = new ArrayList<ModelMBeanOperationInfo>();
        Iterator it = operations.iterator();
        while (it.hasNext()) {
            org.jboss.dom4j.Element oper = (org.jboss.dom4j.Element)it.next();
            String name = oper.elementTextTrim("name");
            String description = oper.elementTextTrim("description");
            String type = oper.elementTextTrim("return-type");
            String impact = oper.attributeValue("impact");
            List params = oper.elements("parameter");
            MBeanParameterInfo[] paramInfo = this.buildParameterInfo(params);
            Descriptor descr = this.getDescriptor(oper, name, "operation");
            descr.setField("role", "operation");
            int operImpact = 2;
            if (impact != null) {
                if (impact.equals("INFO")) {
                    operImpact = 0;
                } else if (impact.equals("ACTION")) {
                    operImpact = 1;
                } else if (impact.equals("ACTION_INFO")) {
                    operImpact = 2;
                }
            }
            if (type == null) {
                type = "void";
            }
            ModelMBeanOperationInfo info = new ModelMBeanOperationInfo(name, description, paramInfo, type, operImpact, descr);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanOperationInfo[0]);
    }

    protected ModelMBeanNotificationInfo[] buildNotificationInfo(List notifications) throws NotCompliantMBeanException {
        ArrayList<ModelMBeanNotificationInfo> infos = new ArrayList<ModelMBeanNotificationInfo>();
        Iterator it = notifications.iterator();
        while (it.hasNext()) {
            org.jboss.dom4j.Element notif = (org.jboss.dom4j.Element)it.next();
            String name = notif.elementTextTrim("name");
            String description = notif.elementTextTrim("description");
            List notifTypes = notif.elements("notification-type");
            Descriptor descr = this.getDescriptor(notif, name, "notification");
            ArrayList<String> types = new ArrayList<String>();
            Iterator iterator = notifTypes.iterator();
            while (iterator.hasNext()) {
                org.jboss.dom4j.Element type = (org.jboss.dom4j.Element)iterator.next();
                types.add(type.getTextTrim());
            }
            ModelMBeanNotificationInfo info = new ModelMBeanNotificationInfo(types.toArray(new String[types.size()]), name, description, descr);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanNotificationInfo[infos.size()]);
    }

    protected ModelMBeanAttributeInfo[] buildAttributeInfo(List attributes) throws NotCompliantMBeanException {
        ArrayList<ModelMBeanAttributeInfo> infos = new ArrayList<ModelMBeanAttributeInfo>();
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            org.jboss.dom4j.Element attr = (org.jboss.dom4j.Element)it.next();
            String name = attr.elementTextTrim("name");
            String description = attr.elementTextTrim("description");
            String type = attr.elementTextTrim("type");
            String access = attr.attributeValue("access");
            String getMethod = attr.attributeValue("getMethod");
            String setMethod = attr.attributeValue("setMethod");
            Descriptor descr = this.getDescriptor(attr, name, "attribute");
            String unconvertedValue = (String)descr.getFieldValue("value");
            if (unconvertedValue != null && !"java.lang.String".equals(type)) {
                descr.setField("value", this.convertValue(unconvertedValue, type));
            } else {
                Object value = this.getAttributeValue(attr, type, "value");
                if (value != null) {
                    descr.setField("value", value);
                }
            }
            String unconvertedDefault = (String)descr.getFieldValue("default");
            if (unconvertedDefault != null && !"java.lang.String".equals(type)) {
                descr.setField("default", this.convertValue(unconvertedDefault, type));
            } else {
                Object value = this.getAttributeValue(attr, type, "default");
                if (value != null) {
                    descr.setField("default", value);
                }
            }
            if (getMethod != null) {
                descr.setField("getMethod", getMethod);
            }
            if (setMethod != null) {
                descr.setField("setMethod", setMethod);
            }
            boolean isReadable = true;
            boolean isWritable = true;
            if (access.equalsIgnoreCase("read-only")) {
                isWritable = false;
            } else if (access.equalsIgnoreCase("write-only")) {
                isReadable = false;
            }
            ModelMBeanAttributeInfo info = new ModelMBeanAttributeInfo(name, type, description, isReadable, isWritable, false, descr);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanAttributeInfo[0]);
    }

    protected Object getAttributeValue(org.jboss.dom4j.Element attribute, String typeName, String which) throws NotCompliantMBeanException {
        Object value = null;
        org.jboss.dom4j.Element descriptors = attribute.element("descriptors");
        if (descriptors != null) {
            Iterator i = descriptors.elementIterator();
            while (i.hasNext()) {
                org.jboss.dom4j.Element descriptor = (org.jboss.dom4j.Element)i.next();
                String name = descriptor.getName();
                if (!name.equals(which) || !descriptor.hasContent()) continue;
                try {
                    String trimAttr;
                    Element element = this.toW3CElement(descriptor);
                    boolean replace = true;
                    boolean trim = true;
                    String replaceAttr = element.getAttribute("replace");
                    if (replaceAttr.length() > 0) {
                        replace = Boolean.valueOf(replaceAttr);
                    }
                    if ((trimAttr = element.getAttribute("trim")).length() > 0) {
                        trim = Boolean.valueOf(trimAttr);
                    }
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> typeClass = Classes.getPrimitiveTypeForName(typeName);
                    if (typeClass == null) {
                        try {
                            typeClass = cl.loadClass(typeName);
                        }
                        catch (ClassNotFoundException e) {
                            throw new JBossNotCompliantMBeanException("Class not found '" + typeName + "'", e);
                        }
                    }
                    if (typeClass.equals(Element.class)) {
                        NodeList nl = element.getChildNodes();
                        for (int j = 0; j < nl.getLength(); ++j) {
                            Node n = nl.item(j);
                            if (n.getNodeType() != 1) continue;
                            value = n;
                            break;
                        }
                        if (replace) {
                            PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
                            if (editor == null) {
                                log.warn("Cannot perform property replace on Element");
                            } else {
                                editor.setValue(value);
                                String text = editor.getAsText();
                                text = StringPropertyReplacer.replaceProperties(text);
                                editor.setAsText(text);
                                value = editor.getValue();
                            }
                        }
                    }
                    if (value != null) break;
                    PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
                    if (editor == null) {
                        throw new JBossNotCompliantMBeanException("No property editor for type '" + typeName + "'");
                    }
                    String attributeText = this.getElementContent(element, trim, replace);
                    editor.setAsText(attributeText);
                    value = editor.getValue();
                    break;
                }
                catch (DocumentException e) {
                    throw new JBossNotCompliantMBeanException("cannot convert '" + which + "' descriptor to org.w3c.dom.Element", e);
                }
            }
        }
        return value;
    }

    private Element toW3CElement(org.jboss.dom4j.Element d4element) throws DocumentException {
        Document d4doc = DocumentFactory.getInstance().createDocument();
        DOMWriter d4Writer = new DOMWriter();
        d4doc.setRootElement(d4element.createCopy());
        org.w3c.dom.Document doc = d4Writer.write(d4doc);
        return doc.getDocumentElement();
    }

    private String getElementContent(Element element, boolean trim, boolean replace) {
        NodeList nl = element.getChildNodes();
        String attributeText = "";
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Text)) continue;
            attributeText = attributeText + ((Text)n).getData();
        }
        if (trim) {
            attributeText = attributeText.trim();
        }
        if (replace) {
            attributeText = StringPropertyReplacer.replaceProperties(attributeText);
        }
        return attributeText;
    }

    protected Object convertValue(String unconverted, String typeName) throws NotCompliantMBeanException {
        Object value = null;
        try {
            value = PropertyEditors.convertValue(unconverted, typeName);
        }
        catch (ClassNotFoundException e) {
            log.debug("Failed to load type class", e);
            throw new NotCompliantMBeanException("Class not found for type: " + typeName);
        }
        catch (IntrospectionException e) {
            throw new NotCompliantMBeanException("No property editor for type=" + typeName);
        }
        return value;
    }

    protected MBeanParameterInfo[] buildParameterInfo(List parameters) {
        Iterator it = parameters.iterator();
        ArrayList<MBeanParameterInfo> infos = new ArrayList<MBeanParameterInfo>();
        while (it.hasNext()) {
            org.jboss.dom4j.Element param = (org.jboss.dom4j.Element)it.next();
            String name = param.elementTextTrim("name");
            String type = param.elementTextTrim("type");
            String descr = param.elementTextTrim("description");
            MBeanParameterInfo info = new MBeanParameterInfo(name, type, descr);
            infos.add(info);
        }
        return infos.toArray(new MBeanParameterInfo[0]);
    }

    protected Descriptor[] buildInterceptors(org.jboss.dom4j.Element descriptor) {
        List interceptors = descriptor.elements("interceptor");
        ArrayList<DescriptorSupport> tmp = new ArrayList<DescriptorSupport>();
        for (int i = 0; i < interceptors.size(); ++i) {
            org.jboss.dom4j.Element interceptor = (org.jboss.dom4j.Element)interceptors.get(i);
            String code = interceptor.attributeValue("code");
            DescriptorSupport interceptorDescr = new DescriptorSupport();
            interceptorDescr.setField("code", code);
            List attributes = interceptor.attributes();
            for (int a = 0; a < attributes.size(); ++a) {
                Attribute attr = (Attribute)attributes.get(a);
                String name = attr.getName();
                String value = attr.getValue();
                value = StringPropertyReplacer.replaceProperties(value);
                interceptorDescr.setField(name, value);
            }
            tmp.add(interceptorDescr);
        }
        Descriptor[] descriptors = new Descriptor[tmp.size()];
        tmp.toArray(descriptors);
        return descriptors;
    }
}

