/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.aop.DispatcherConnectException;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.remoting.ClusterConstants;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.ha.client.loadbalance.AopLoadBalancePolicy;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.logging.Logger;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.TransactionPropagationContextUtil;

public class ClusterChooserInterceptor
implements Interceptor,
ClusterConstants,
Serializable {
    private static final long serialVersionUID = -8666382019058421135L;
    private static Logger log = Logger.getLogger(ClusterChooserInterceptor.class);
    private static boolean trace = log.isTraceEnabled();
    public static final ClusterChooserInterceptor singleton = new ClusterChooserInterceptor();
    private static final Map<Object, InvokerLocator> txStickyTargets = Collections.synchronizedMap(new WeakHashMap());

    public String getName() {
        return "ClusterChooserInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        LoadBalancePolicy lb = (LoadBalancePolicy)invocation.getMetaData((Object)"CLUSTERED_REMOTING", (Object)"LOADBALANCE_POLICY");
        FamilyWrapper family = (FamilyWrapper)invocation.getMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_FAMILY_WRAPPER");
        int failoverCounter = 0;
        String familyName = family.get().getFamilyName();
        invocation.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_FAMILY", (Object)familyName, PayloadKey.AS_IS);
        InvokerLocator target = null;
        InvokerLocator txStickyTarget = null;
        Object tpc = this.getTransactionPropagationContext();
        if (tpc != null && (txStickyTarget = txStickyTargets.get(tpc)) != null) {
            if (family.get().getTargets().contains(txStickyTarget)) {
                if (trace) {
                    log.trace((Object)("Using transaction sticky target: " + txStickyTarget));
                }
                target = txStickyTarget;
            } else {
                throw new RuntimeException("Current transaction is stuck to " + txStickyTarget + " which is no longer available.  Halting invocation.");
            }
        }
        if (target == null) {
            target = lb instanceof AopLoadBalancePolicy ? (InvokerLocator)((AopLoadBalancePolicy)lb).chooseTarget(family.get(), invocation) : (InvokerLocator)lb.chooseTarget(family.get());
        }
        Object lastException = null;
        boolean failoverAuthorized = true;
        while (target != null && failoverAuthorized) {
            invocation.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"FAILOVER_COUNTER", (Object)new Integer(failoverCounter), PayloadKey.AS_IS);
            invocation.getMetaData().addMetaData((Object)"REMOTING", (Object)"INVOKER_LOCATOR", (Object)target, PayloadKey.AS_IS);
            invocation.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_VIEW_ID", (Object)new Long(family.get().getCurrentViewId()), PayloadKey.AS_IS);
            boolean definitivlyRemoveNodeOnFailure = true;
            lastException = null;
            try {
                Object rsp = invocation.invokeNext();
                List newReplicants = (List)invocation.getResponseAttachment((Object)"replicants");
                if (newReplicants != null) {
                    long newViewId = (Long)invocation.getResponseAttachment((Object)"viewId");
                    family.get().updateClusterInfo(newReplicants, newViewId);
                }
                if (txStickyTarget == null && this.invocationHasReachedAServer(target)) {
                    if (trace) {
                        log.trace((Object)("Setting " + target + " as the new sticky target"));
                    }
                    txStickyTarget = target;
                }
                return rsp;
            }
            catch (DispatcherConnectException dce) {
                lastException = dce;
            }
            catch (CannotConnectException ex) {
                lastException = ex;
            }
            catch (GenericClusteringException gce) {
                lastException = gce;
                if (gce.getCompletionStatus() == 1) {
                    if (family.get().getTargets().size() >= failoverCounter && !gce.isDefinitive()) {
                        definitivlyRemoveNodeOnFailure = false;
                    }
                }
                this.invocationHasReachedAServer(target);
                throw new RuntimeException("Clustering exception thrown", (Throwable)((Object)gce));
            }
            catch (Throwable t) {
                if (t.getCause() instanceof GenericClusteringException) {
                    GenericClusteringException gce = (GenericClusteringException)((Object)t.getCause());
                    lastException = gce;
                    if (gce.getCompletionStatus() == 1) {
                        if (family.get().getTargets().size() >= failoverCounter && !gce.isDefinitive()) {
                            definitivlyRemoveNodeOnFailure = false;
                        }
                    }
                    this.invocationHasReachedAServer(target);
                    throw new RuntimeException("Clustering exception thrown", (Throwable)((Object)gce));
                }
                throw t;
            }
            family.get().removeDeadTarget(target);
            if (!definitivlyRemoveNodeOnFailure) {
                family.get().resetView();
            }
            if ((target = (InvokerLocator)lb.chooseTarget(family.get())) == null) {
                if (lastException != null) {
                    throw new RuntimeException("cluster invocation failed, last exception was: ", (Throwable)lastException);
                }
                throw new RuntimeException("cluster invocation failed");
            }
            failoverAuthorized = this.txContextAllowsFailover();
            ++failoverCounter;
        }
        if (!failoverAuthorized) {
            throw new RuntimeException("Current transaction is stuck to " + txStickyTarget + " which is no longer available.  Halting invocation.");
        }
        throw new RuntimeException("Unreachable?: Service unavailable.");
    }

    private Object getTransactionPropagationContext() {
        TransactionPropagationContextFactory factory = TransactionPropagationContextUtil.getTPCFactoryClientSide();
        return factory != null ? factory.getTransactionPropagationContext() : null;
    }

    private boolean txContextAllowsFailover() {
        Object tpc = this.getTransactionPropagationContext();
        if (tpc != null) {
            return !txStickyTargets.containsKey(tpc);
        }
        return true;
    }

    private boolean invocationHasReachedAServer(InvokerLocator target) {
        Object tpc = this.getTransactionPropagationContext();
        if (tpc != null) {
            txStickyTargets.put(tpc, target);
        }
        return tpc != null;
    }
}

