/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import org.jboss.ha.framework.interfaces.CachableMarshalledValue;
import org.jboss.ha.framework.interfaces.ObjectStreamSource;
import org.jboss.ha.framework.server.MarshalledValueObjectStreamSource;

public class SimpleCachableMarshalledValue
implements Externalizable,
CachableMarshalledValue {
    private byte[] serializedForm;
    private Serializable raw;
    private int hashCode;
    private transient ObjectStreamSource objectStreamSource;

    public SimpleCachableMarshalledValue() {
    }

    public SimpleCachableMarshalledValue(Serializable obj) {
        this.raw = obj;
        if (this.raw != null) {
            this.hashCode = this.raw.hashCode();
        }
    }

    public SimpleCachableMarshalledValue(Serializable obj, ObjectStreamSource streamSource) {
        this(obj);
        this.objectStreamSource = streamSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Serializable get() throws IOException, ClassNotFoundException {
        if (this.raw == null && this.serializedForm != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.serializedForm);
            ObjectInput mvis = this.getObjectStreamSource().getObjectInput(bais);
            try {
                this.raw = (Serializable)mvis.readObject();
                this.serializedForm = null;
            }
            finally {
                mvis.close();
            }
        }
        return this.raw;
    }

    @Override
    public synchronized byte[] toByteArray() throws IOException {
        if (this.serializedForm == null) {
            this.serializedForm = this.serialize();
        }
        this.raw = null;
        return this.serializedForm;
    }

    public Serializable peekUnderlyingObject() {
        return this.raw;
    }

    public byte[] peekSerializedForm() {
        return this.serializedForm;
    }

    public ObjectStreamSource getObjectStreamSource() {
        if (this.objectStreamSource == null) {
            this.objectStreamSource = new MarshalledValueObjectStreamSource();
        }
        return this.objectStreamSource;
    }

    public void setObjectStreamSource(ObjectStreamSource objectStreamSource) {
        this.objectStreamSource = objectStreamSource;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean equals = false;
        if (obj instanceof SimpleCachableMarshalledValue) {
            SimpleCachableMarshalledValue mv = (SimpleCachableMarshalledValue)obj;
            if (this.raw != null && mv.raw != null) {
                equals = this.raw.equals(mv.raw);
            } else if (this.serializedForm != null && mv.serializedForm != null) {
                equals = this.serializedForm == mv.serializedForm ? true : Arrays.equals(this.serializedForm, mv.serializedForm);
            } else {
                byte[] us = null;
                byte[] them = null;
                try {
                    us = this.serialize();
                    them = mv.serialize();
                    equals = Arrays.equals(us, them);
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot serialize " + (us == null && this.raw != null ? "us" : "them"), e);
                }
            }
        }
        return equals;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("{raw=");
        sb.append(this.raw == null ? "null" : this.raw);
        sb.append("serialized=");
        sb.append(this.serializedForm == null ? "false" : "true");
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        this.serializedForm = null;
        if (length > 0) {
            this.serializedForm = new byte[length];
            in.readFully(this.serializedForm);
        }
        this.hashCode = in.readInt();
    }

    @Override
    public synchronized void writeExternal(ObjectOutput out) throws IOException {
        byte[] bytes = this.serialize();
        int length = bytes != null ? bytes.length : 0;
        out.writeInt(length);
        if (length > 0) {
            out.write(bytes);
        }
        out.writeInt(this.hashCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serialize() throws IOException {
        byte[] result = this.serializedForm;
        if (result == null && this.raw != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutput mvos = this.getObjectStreamSource().getObjectOutput(baos);
            mvos.writeObject(this.raw);
            mvos.flush();
            try {
                result = baos.toByteArray();
            }
            finally {
                mvos.close();
            }
        }
        return result;
    }
}

