/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server.lock;

import java.io.Serializable;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.lock.LocalLockHandler;
import org.jboss.ha.framework.server.lock.TimeoutException;
import org.jboss.ha.framework.server.lock.YieldingGloballyExclusiveClusterLockSupport;

public class SharedLocalYieldingClusterLockManager {
    private ClusterNode localNode;
    private ConcurrentMap<Serializable, LocalLock> localLocks = new ConcurrentHashMap<Serializable, LocalLock>();
    private final YieldingGloballyExclusiveClusterLockSupport clusterSupport;

    public SharedLocalYieldingClusterLockManager(String serviceHAName, HAPartition partition) {
        ClusterHandler handler = new ClusterHandler();
        this.clusterSupport = new YieldingGloballyExclusiveClusterLockSupport(serviceHAName, partition, handler);
    }

    public LockResult lock(Serializable lockName, long timeout) throws TimeoutException, InterruptedException {
        return this.lock(lockName, timeout, false);
    }

    public LockResult lock(Serializable lockName, long timeout, boolean newLock) throws TimeoutException, InterruptedException {
        if (this.localNode == null) {
            throw new IllegalStateException("Null localNode");
        }
        LockResult result = null;
        LocalLock localLock = this.getLocalLock(lockName, false);
        if (localLock == null) {
            if (newLock) {
                localLock = this.getLocalLock(lockName, true);
                localLock.lock(this.localNode, timeout);
                result = localLock.localLockCount.get() == 1 ? LockResult.NEW_LOCK : LockResult.ALREADY_HELD;
            } else {
                this.clusterSupport.lock(lockName, timeout);
                result = LockResult.ACQUIRED_FROM_CLUSTER;
            }
        } else {
            localLock.localLockCount.incrementAndGet();
            try {
                if (this.localNode.equals(localLock.holder)) {
                    result = LockResult.ALREADY_HELD;
                    if (localLock.removable && localLock != this.getLocalLock(lockName, false)) {
                        LockResult lockResult = this.lock(lockName, timeout, newLock);
                        return lockResult;
                    }
                } else {
                    this.clusterSupport.lock(lockName, timeout);
                    result = LockResult.ACQUIRED_FROM_CLUSTER;
                }
            }
            finally {
                LocalLock current;
                if (result != LockResult.ALREADY_HELD && (current = (LocalLock)this.localLocks.get(lockName)) == localLock) {
                    localLock.localLockCount.decrementAndGet();
                }
            }
        }
        return result;
    }

    public void unlock(Serializable lockName, boolean remove) {
        LocalLock lock = this.getLocalLock(lockName, false);
        if (remove && lock != null) {
            lock.removable = true;
        }
        this.clusterSupport.unlock(lockName);
        if (lock != null && lock.removable && lock.localLockCount.get() == 0) {
            this.localLocks.remove(lockName, lock);
        }
    }

    public void start() throws Exception {
        this.clusterSupport.start();
    }

    public void stop() throws Exception {
        this.clusterSupport.stop();
    }

    private LocalLock getLocalLock(Serializable categoryName, boolean create) {
        LocalLock existing;
        LocalLock category = (LocalLock)this.localLocks.get(categoryName);
        if (category == null && create && (existing = this.localLocks.putIfAbsent(categoryName, category = new LocalLock())) != null) {
            category = existing;
        }
        return category;
    }

    private class ClusterHandler
    implements LocalLockHandler {
        private ClusterHandler() {
        }

        @Override
        public ClusterNode getLocalNode(ClusterNode localNode) {
            return SharedLocalYieldingClusterLockManager.this.localNode;
        }

        @Override
        public void setLocalNode(ClusterNode localNode) {
            SharedLocalYieldingClusterLockManager.this.localNode = localNode;
        }

        @Override
        public void lockFromCluster(Serializable lockName, ClusterNode caller, long timeout) throws TimeoutException, InterruptedException {
            LocalLock lock = SharedLocalYieldingClusterLockManager.this.getLocalLock(lockName, true);
            lock.lock(caller, timeout);
            if (!SharedLocalYieldingClusterLockManager.this.localNode.equals(caller)) {
                SharedLocalYieldingClusterLockManager.this.localLocks.remove(lockName, lock);
            }
        }

        @Override
        public ClusterNode getLockHolder(Serializable lockName) {
            LocalLock lock = SharedLocalYieldingClusterLockManager.this.getLocalLock(lockName, false);
            return lock == null ? null : lock.holder;
        }

        @Override
        public void unlockFromCluster(Serializable lockName, ClusterNode caller) {
            LocalLock lock = SharedLocalYieldingClusterLockManager.this.getLocalLock(lockName, false);
            if (lock != null) {
                lock.unlock(caller);
            }
        }
    }

    private class LocalLock {
        private volatile ClusterNode holder;
        private volatile boolean removable;
        private final Queue<Thread> waiters = new ConcurrentLinkedQueue<Thread>();
        private final AtomicInteger localLockCount = new AtomicInteger();

        private LocalLock() {
        }

        private void lock(ClusterNode caller, long timeout) throws TimeoutException {
            block9: {
                if (SharedLocalYieldingClusterLockManager.this.localNode.equals(caller)) {
                    this.localLockCount.incrementAndGet();
                    this.holder = SharedLocalYieldingClusterLockManager.this.localNode;
                } else {
                    long deadline = System.currentTimeMillis() + timeout;
                    boolean wasInterrupted = false;
                    Thread current = Thread.currentThread();
                    this.waiters.add(current);
                    try {
                        while (this.waiters.peek() != current || this.localLockCount.get() > 0) {
                            LockSupport.parkUntil(deadline);
                            if (Thread.interrupted()) {
                                wasInterrupted = true;
                            }
                            if (System.currentTimeMillis() < deadline) continue;
                            if (this.waiters.peek() == current && this.localLockCount.get() <= 0) break;
                            throw new TimeoutException(this.holder);
                        }
                        if (this.localLockCount.get() == 0) {
                            this.holder = caller;
                            break block9;
                        }
                        throw new TimeoutException(this.holder);
                    }
                    finally {
                        this.waiters.remove();
                        if (wasInterrupted) {
                            current.interrupt();
                        }
                    }
                }
            }
        }

        private void unlock(ClusterNode caller) {
            if (caller.equals(this.holder)) {
                if (SharedLocalYieldingClusterLockManager.this.localNode.equals(caller)) {
                    if (this.localLockCount.decrementAndGet() == 0) {
                        this.holder = null;
                    }
                } else {
                    this.holder = null;
                }
                if (this.holder == null) {
                    LockSupport.unpark(this.waiters.peek());
                }
            }
        }
    }

    public static enum LockResult {
        ACQUIRED_FROM_CLUSTER,
        ALREADY_HELD,
        NEW_LOCK;

    }
}

