/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server.lock;

import java.io.Serializable;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.lock.AbstractClusterLockSupport;
import org.jboss.ha.framework.server.lock.ClusterLockState;
import org.jboss.ha.framework.server.lock.LocalLockHandler;
import org.jboss.ha.framework.server.lock.RemoteLockResponse;

public class YieldingGloballyExclusiveClusterLockSupport
extends AbstractClusterLockSupport {
    public YieldingGloballyExclusiveClusterLockSupport(String serviceHAName, HAPartition partition, LocalLockHandler handler) {
        super(serviceHAName, partition, handler);
    }

    @Override
    public void unlock(Serializable lockId) {
        ClusterNode myself = this.getLocalClusterNode();
        if (myself == null) {
            throw new IllegalStateException("Must call start() before first call to unlock()");
        }
        ClusterLockState category = this.getClusterLockState(lockId, false);
        if (category == null) {
            this.getLocalHandler().unlockFromCluster(lockId, myself);
        } else if (myself.equals(category.getHolder())) {
            category.invalidate();
            this.getLocalHandler().unlockFromCluster(lockId, myself);
            this.removeLockState(category);
        }
    }

    @Override
    protected ClusterLockState getClusterLockState(Serializable categoryName) {
        return this.getClusterLockState(categoryName, false);
    }

    @Override
    protected RemoteLockResponse yieldLock(ClusterLockState lockState, ClusterNode caller, long timeout) {
        if (this.getLocalClusterNode().equals(lockState.getHolder())) {
            return this.getLock(lockState.lockId, lockState, caller, timeout);
        }
        return new RemoteLockResponse(this.getLocalClusterNode(), RemoteLockResponse.Flag.REJECT, lockState.getHolder());
    }

    @Override
    protected RemoteLockResponse handleLockSuccess(ClusterLockState lockState, ClusterNode caller) {
        if (this.getLocalClusterNode().equals(caller)) {
            this.recordLockHolder(lockState, caller);
        } else {
            lockState.invalidate();
            this.removeLockState(lockState);
        }
        return new RemoteLockResponse(this.getLocalClusterNode(), RemoteLockResponse.Flag.OK);
    }
}

