/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ha.framework.interfaces;

import java.util.EventObject;


/**
 * Basic interface for clustered services
 * 
 * @author Paul Ferraro
 *
 * @param <E> type of event generated by this service
 */
public interface HAService<E extends EventObject> extends HAServiceKeyProvider, EventListener<E>
{
   String getServiceHAName();
   
   void setHAPartition(HAPartition partition);

   void setServiceHAName(String name);

   /**
    * Test whether the thread context classloader should be used in RPC calls.
    * 
    * @return whether the thread context classloader should be used in RPC calls.
    */
   boolean isRegisterThreadContextClassLoader();
   
   /**
    * Sets a flag specifying whether the calling thread's context classloader
    * should be used when making RPC calls.  This flag must be set before the
    * RPC handler is registered in startService().  The default value is false.
    * This would typically be used in conjunction with a scoped classloader.
    * 
    * @param register whether to use the thread context classloader when
    * registering the service's RPC handler. 
    * 
    */
   void setRegisterThreadContextClassLoader(boolean register);

   void create() throws Exception;
   void start() throws Exception;
   void stop();
   void destroy();
}