/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server.ispn;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.config.Configuration;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.util.SimpleImmutableEntry;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.server.ispn.InfinispanHAPartitionCacheHandler;
import org.jboss.ha.framework.server.spi.ManagedDistributedState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Listener
public class DistributedState
implements ManagedDistributedState {
    private final ConcurrentHashMap<String, List<DistributedState.DSListener>> keyListeners = new ConcurrentHashMap();
    private volatile Cache<Serializable, Serializable> cache;
    private volatile boolean replAsync;
    private volatile InfinispanHAPartitionCacheHandler<Serializable, Serializable> cacheHandler;

    public InfinispanHAPartitionCacheHandler<Serializable, Serializable> getCacheHandler() {
        return this.cacheHandler;
    }

    public void setCacheHandler(InfinispanHAPartitionCacheHandler<Serializable, Serializable> cacheHandler) {
        this.cacheHandler = cacheHandler;
    }

    public void createService() throws Exception {
    }

    public void startService() throws Exception {
        this.internalSetClusteredCache(this.cacheHandler.getCache());
        this.cache.addListener((Object)this);
    }

    public void stopService() throws Exception {
        this.cache.removeListener((Object)this);
    }

    public void destroyService() throws Exception {
    }

    public void set(String category, Serializable key, Serializable value) throws Exception {
        this.set(category, key, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String category, Serializable key, Serializable value, boolean asynchronousCall) throws Exception {
        this.cache.startBatch();
        boolean commit = false;
        try {
            this.cache.put(this.buildValueCollectionKey(category, key), (Object)value);
            AtomicMap<Serializable, Void> m = this.getKeysPerCategoryCollection(category);
            m.put((Object)key, null);
            commit = true;
        }
        finally {
            this.cache.endBatch(commit);
        }
    }

    public Serializable remove(String category, Serializable key) throws Exception {
        return this.remove(category, key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable remove(String category, Serializable key, boolean asynchronousCall) throws Exception {
        Serializable retVal = this.get(category, key);
        if (retVal != null) {
            this.cache.startBatch();
            boolean commit = false;
            try {
                this.cache.remove(this.buildValueCollectionKey(category, key));
                AtomicMap<Serializable, Void> m = this.getKeysPerCategoryCollection(category);
                m.remove((Object)key);
                commit = true;
            }
            finally {
                this.cache.endBatch(commit);
            }
        }
        return retVal;
    }

    public Serializable get(String category, Serializable key) {
        try {
            return (Serializable)this.cache.get(this.buildValueCollectionKey(category, key));
        }
        catch (CacheException ce) {
            return null;
        }
    }

    public Collection<String> getAllCategories() {
        try {
            Set keys = this.cache.keySet();
            if (keys.isEmpty()) {
                return null;
            }
            LinkedList<String> categories = new LinkedList<String>();
            for (Serializable key : keys) {
                if (!(key instanceof String)) continue;
                categories.add((String)((Object)key));
            }
            return categories;
        }
        catch (CacheException ce) {
            return null;
        }
    }

    public Collection<Serializable> getAllKeys(String category) {
        try {
            AtomicMap<Serializable, Void> m = this.getKeysPerCategoryCollection(category);
            return m.keySet();
        }
        catch (CacheException ce) {
            return null;
        }
    }

    public Collection<Serializable> getAllValues(String category) {
        try {
            Collection<Serializable> keys = this.getAllKeys(category);
            if (keys == null) {
                return null;
            }
            ArrayList<Serializable> values = new ArrayList<Serializable>();
            for (Serializable key : keys) {
                values.add((Serializable)this.cache.get(this.buildValueCollectionKey(category, key)));
            }
            return values;
        }
        catch (CacheException ce) {
            return null;
        }
    }

    public void registerDSListenerEx(String category, DistributedState.DSListenerEx subscriber) {
        this.registerDSListener(category, (DistributedState.DSListener)subscriber);
    }

    public void unregisterDSListenerEx(String category, DistributedState.DSListenerEx subscriber) {
        this.unregisterDSListener(category, (DistributedState.DSListener)subscriber);
    }

    public void registerDSListener(String category, DistributedState.DSListener subscriber) {
        List<DistributedState.DSListener> existing;
        List<DistributedState.DSListener> listeners = this.keyListeners.get(category);
        if (listeners == null && (existing = this.keyListeners.putIfAbsent(category, listeners = new CopyOnWriteArrayList<DistributedState.DSListener>())) != null) {
            listeners = existing;
        }
        listeners.add(subscriber);
    }

    public void unregisterDSListener(String category, DistributedState.DSListener subscriber) {
        List<DistributedState.DSListener> listeners = this.keyListeners.get(category);
        if (listeners != null) {
            listeners.remove(subscriber);
            this.keyListeners.remove(category, Collections.emptyList());
        }
    }

    protected void notifyKeyListeners(String category, Serializable key, Serializable value, boolean locallyModified) {
        List<DistributedState.DSListener> listeners = this.keyListeners.get(category);
        if (listeners == null) {
            return;
        }
        for (DistributedState.DSListener listener : listeners) {
            listener.valueHasChanged(category, key, value, locallyModified);
        }
    }

    protected void notifyKeyListenersOfRemove(String category, Serializable key, Serializable oldContent, boolean locallyModified) {
        List<DistributedState.DSListener> listeners = this.keyListeners.get(category);
        if (listeners == null) {
            return;
        }
        for (DistributedState.DSListener listener : listeners) {
            listener.keyHasBeenRemoved(category, key, oldContent, locallyModified);
        }
    }

    protected void cleanupKeyListeners() {
    }

    @CacheEntryModified
    public void nodeModified(CacheEntryModifiedEvent event) {
        if (event.isPre()) {
            return;
        }
        Object key = event.getKey();
        if (key instanceof SimpleImmutableEntry) {
            SimpleImmutableEntry entry = (SimpleImmutableEntry)key;
            this.notifyKeyListeners((String)entry.getKey(), (Serializable)entry.getValue(), (Serializable)event.getValue(), event.isOriginLocal());
        }
    }

    @CacheEntryRemoved
    public void nodeRemoved(CacheEntryRemovedEvent event) {
        if (event.isPre()) {
            return;
        }
        Object key = event.getKey();
        if (key instanceof SimpleImmutableEntry) {
            SimpleImmutableEntry entry = (SimpleImmutableEntry)key;
            this.notifyKeyListenersOfRemove((String)entry.getKey(), (Serializable)entry.getValue(), (Serializable)event.getValue(), event.isOriginLocal());
        }
    }

    private void internalSetClusteredCache(Cache<Serializable, Serializable> cache) {
        this.cache = cache;
        if (this.cache != null) {
            Configuration.CacheMode cm = cache.getConfiguration().getCacheMode();
            if (Configuration.CacheMode.REPL_ASYNC == cm) {
                this.replAsync = true;
            } else if (Configuration.CacheMode.REPL_SYNC == cm) {
                this.replAsync = false;
            } else {
                throw new IllegalStateException("Cache must be configured for replication, not " + cm);
            }
        }
    }

    private SimpleImmutableEntry<String, Serializable> buildValueCollectionKey(String category, Serializable dskey) {
        return new SimpleImmutableEntry((Object)category, (Object)dskey);
    }

    private AtomicMap<Serializable, Void> getKeysPerCategoryCollection(String category) {
        return AtomicMapLookup.getAtomicMap(this.cache, (Object)category, (boolean)true);
    }
}

