/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.jndi.ispn;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.infinispan.CacheException;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.TreeCache;
import org.jboss.ha.framework.server.ispn.InfinispanHAPartitionCacheHandler;
import org.jboss.ha.ispn.tree.DefaultTreeCacheFactory;
import org.jboss.ha.ispn.tree.TreeCacheFactory;
import org.jboss.logging.Logger;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;
import org.jnp.interfaces.NamingParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedTreeManager
implements Naming,
org.jboss.ha.jndi.spi.DistributedTreeManager {
    private static final Logger LOG = Logger.getLogger(DistributedTreeManager.class);
    private static final NamingParser PARSER = new NamingParser();
    private static final String DEFAULT_ROOT = "__HA_JNDI__";
    private static final Fqn FQN_ROOT = Fqn.fromString((String)"__HA_JNDI__");
    protected volatile TreeCache<String, Binding> m_cache;
    private volatile InfinispanHAPartitionCacheHandler<String, Binding> cacheHandler;
    private final Naming haStub;
    private volatile TreeCacheFactory treeCacheFactory;

    public DistributedTreeManager(Naming haStub) {
        this.haStub = haStub;
        this.treeCacheFactory = new DefaultTreeCacheFactory();
    }

    public DistributedTreeManager(Naming haStub, TreeCacheFactory factory) {
        this.haStub = haStub;
        this.treeCacheFactory = factory;
    }

    public InfinispanHAPartitionCacheHandler<String, Binding> getCacheHandler() {
        return this.cacheHandler;
    }

    public void setCacheHandler(InfinispanHAPartitionCacheHandler<String, Binding> cacheHandler) {
        this.cacheHandler = cacheHandler;
    }

    public void init() {
        this.m_cache = this.treeCacheFactory.createTreeCache(this.cacheHandler.getCache());
        LOG.debug((Object)"initializing HAJNDITreeCache root");
    }

    public void shutdown() {
        this.m_cache = null;
    }

    public Naming getHAStub() {
        return this.haStub;
    }

    public void setHAStub(Naming stub) {
    }

    public void bind(Name name, Object obj, String className) throws NamingException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("bind, name=" + name));
        }
        this.internalBind(name, obj, className, false);
    }

    public void rebind(Name name, Object obj, String className) throws NamingException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("rebind, name=" + name));
        }
        this.internalBind(name, obj, className, true);
    }

    public void unbind(Name name) throws NamingException {
        Fqn ctx;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("unbind, name=" + name));
        }
        if (name.isEmpty()) {
            throw new InvalidNameException("Name is empty");
        }
        try {
            Fqn temp = Fqn.fromRelativeFqn((Fqn)FQN_ROOT, (Fqn)Fqn.fromString((String)name.toString()));
            if (this.m_cache.getRoot().hasChild(temp)) {
                this.m_cache.removeNode(temp);
                return;
            }
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
        int size = name.size();
        String key = name.get(size - 1);
        if (size > 1) {
            String prefix = name.getPrefix(size - 1).toString();
            Fqn fqn = Fqn.fromString((String)prefix);
            ctx = Fqn.fromRelativeFqn((Fqn)FQN_ROOT, (Fqn)fqn);
        } else {
            ctx = FQN_ROOT;
        }
        try {
            Object removed = this.m_cache.remove(ctx, (Object)key);
            if (removed == null) {
                if (!this.m_cache.getRoot().hasChild(ctx)) {
                    throw new NotContextException(name.getPrefix(size - 1).toString() + " not a context");
                }
                throw new NameNotFoundException(key + " not bound");
            }
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
    }

    public Object lookup(Name name) throws NamingException {
        Fqn ctx;
        boolean trace = LOG.isTraceEnabled();
        if (trace) {
            LOG.trace((Object)("lookup, name=" + name));
        }
        if (name.isEmpty()) {
            return new NamingContext(null, PARSER.parse(""), this.getHAStub());
        }
        try {
            Node n = this.m_cache.getRoot().getChild(Fqn.fromRelativeFqn((Fqn)FQN_ROOT, (Fqn)Fqn.fromString((String)name.toString())));
            if (n != null) {
                Name fullName = (Name)name.clone();
                return new NamingContext(null, fullName, this.getHAStub());
            }
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
        int size = name.size();
        String key = name.get(size - 1);
        if (size > 1) {
            String prefix = name.getPrefix(size - 1).toString();
            Fqn fqn = Fqn.fromString((String)prefix);
            ctx = Fqn.fromRelativeFqn((Fqn)FQN_ROOT, (Fqn)fqn);
        } else {
            ctx = FQN_ROOT;
        }
        try {
            Binding b = (Binding)this.m_cache.get(ctx, (Object)key);
            return b != null ? b.getObject() : null;
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
    }

    public Collection<NameClassPair> list(Name name) throws NamingException {
        Fqn ctx;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("list, name=" + name));
        }
        String ctxName = "";
        int size = name.size();
        if (size >= 1) {
            ctxName = name.toString();
            Fqn fqn = Fqn.fromString((String)ctxName);
            ctx = Fqn.fromRelativeFqn((Fqn)FQN_ROOT, (Fqn)fqn);
        } else {
            ctx = FQN_ROOT;
        }
        boolean exists = this.m_cache.getRoot().hasChild(ctx);
        if (!exists) {
            try {
                return Collections.list(new InitialContext().list(name));
            }
            catch (NamingException e) {
                throw new NotContextException(ctxName + " not a context");
            }
        }
        try {
            LinkedList<NameClassPair> list = new LinkedList<NameClassPair>();
            Node base = this.m_cache.getRoot().getChild(ctx);
            if (base != null) {
                for (Binding b : base.getData().values()) {
                    list.add(new NameClassPair(b.getName(), b.getClassName(), true));
                }
                Set children = base.getChildrenNames();
                if (children != null && !children.isEmpty()) {
                    for (Object child : children) {
                        String node = (String)child;
                        Name fullName = (Name)name.clone();
                        fullName.add(node);
                        list.add(new NameClassPair(node, NamingContext.class.getName(), true));
                    }
                }
            }
            return list;
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
    }

    public Collection<Binding> listBindings(Name name) throws NamingException {
        Fqn ctx;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("listBindings, name=" + name));
        }
        String ctxName = "";
        int size = name.size();
        if (size >= 1) {
            ctxName = name.toString();
            Fqn fqn = Fqn.fromString((String)ctxName);
            ctx = Fqn.fromRelativeFqn((Fqn)FQN_ROOT, (Fqn)fqn);
        } else {
            ctx = FQN_ROOT;
        }
        boolean exists = this.m_cache.getRoot().hasChild(ctx);
        if (!exists) {
            try {
                return Collections.list(new InitialContext().listBindings(name));
            }
            catch (NamingException e) {
                throw new NotContextException(ctxName + " not a context");
            }
        }
        try {
            LinkedList<Binding> list = new LinkedList<Binding>();
            Node node = this.m_cache.getRoot().getChild(ctx);
            if (node != null) {
                Set children;
                Map data = node.getData();
                if (data != null && !data.isEmpty()) {
                    list.addAll(data.values());
                }
                if ((children = node.getChildrenNames()) != null && !children.isEmpty()) {
                    for (Object obj : children) {
                        String child = (String)obj;
                        Name fullName = (Name)name.clone();
                        fullName.add(child);
                        NamingContext subCtx = new NamingContext(null, fullName, this.getHAStub());
                        list.add(new Binding(child, NamingContext.class.getName(), subCtx, true));
                    }
                }
            }
            return list;
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
    }

    public Context createSubcontext(Name name) throws NamingException {
        Fqn pctx;
        int size;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("createSubcontext, name=" + name));
        }
        if ((size = name.size()) == 0) {
            throw new InvalidNameException("Name is empty");
        }
        String str = name.toString();
        Fqn fqn = Fqn.fromString((String)str);
        Fqn ctx = Fqn.fromRelativeFqn((Fqn)FQN_ROOT, (Fqn)fqn);
        if (this.m_cache.getRoot().hasChild(ctx)) {
            throw new NameAlreadyBoundException(str);
        }
        String newctx = name.get(size - 1);
        if (size > 1) {
            String prefix = name.getPrefix(size - 1).toString();
            Fqn fqn2 = Fqn.fromString((String)prefix);
            pctx = Fqn.fromRelativeFqn((Fqn)FQN_ROOT, (Fqn)fqn2);
        } else {
            pctx = FQN_ROOT;
        }
        boolean exists = this.m_cache.getRoot().hasChild(pctx);
        if (!exists) {
            throw new NotContextException(name.getPrefix(size - 1).toString());
        }
        Fqn newf = Fqn.fromRelativeFqn((Fqn)pctx, (Fqn)Fqn.fromString((String)newctx));
        try {
            this.m_cache.put(newf, new HashMap());
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
        Name fullName = PARSER.parse("");
        fullName.addAll(name);
        return new NamingContext(null, fullName, this.getHAStub());
    }

    private void internalBind(Name name, Object obj, String className, boolean rebind) throws NamingException {
        Node node;
        Fqn ctx;
        if (name.isEmpty()) {
            throw new InvalidNameException("Name is empty");
        }
        int size = name.size();
        String key = name.get(size - 1);
        if (size > 1) {
            String prefix = name.getPrefix(size - 1).toString();
            Fqn fqn = Fqn.fromString((String)prefix);
            ctx = Fqn.fromRelativeFqn((Fqn)FQN_ROOT, (Fqn)fqn);
        } else {
            ctx = FQN_ROOT;
        }
        boolean exists = this.m_cache.getRoot().hasChild(ctx);
        if (!exists) {
            throw new NotContextException(name.getPrefix(size - 1).toString() + " not a context");
        }
        if (!rebind && (node = this.m_cache.getRoot().getChild(ctx)) != null && node.get((Object)key) != null) {
            throw new NameAlreadyBoundException(key);
        }
        this.m_cache.put(ctx, (Object)key, (Object)new Binding(key, className, obj, true));
    }
}

