/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.ispn;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.ha.framework.server.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.ha.framework.server.lock.TimeoutException;
import org.jboss.ha.ispn.atomic.AtomicMapFactory;
import org.jboss.ha.ispn.invoker.CacheInvoker;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.distributedcache.impl.IncomingDistributableSessionDataImpl;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.AtomicMapEntry;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.SessionAttributeStorage;
import org.jboss.web.tomcat.service.session.distributedcache.spi.BatchingManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionMetadata;
import org.jboss.web.tomcat.service.session.distributedcache.spi.IncomingDistributableSessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingDistributableSessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.SessionOwnershipSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Listener
public class DistributedCacheManager<T extends OutgoingDistributableSessionData>
implements org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManager<T>,
SessionOwnershipSupport {
    private static final Logger log = Logger.getLogger(DistributedCacheManager.class);
    private static Map<SharedLocalYieldingClusterLockManager.LockResult, SessionOwnershipSupport.LockResult> lockResultMap = DistributedCacheManager.lockResultMap();
    private final LocalDistributableSessionManager manager;
    private final SharedLocalYieldingClusterLockManager lockManager;
    private final SessionAttributeStorage<T> attributeStorage;
    private final Cache<?, ?> cache;
    private final CacheInvoker invoker;
    private final BatchingManager batchingManager;
    private final boolean passivationEnabled;
    final AtomicMapFactory atomicMapFactory;
    private long lockTimeout = 30000L;

    static String mask(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        int length = sessionId.length();
        if (length <= 8) {
            return sessionId;
        }
        return sessionId.substring(0, 2) + "****" + sessionId.substring(length - 6, length);
    }

    static RuntimeException getRuntimeException(String message, Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(message != null ? message : e.toString(), e);
    }

    private static Map<SharedLocalYieldingClusterLockManager.LockResult, SessionOwnershipSupport.LockResult> lockResultMap() {
        EnumMap<SharedLocalYieldingClusterLockManager.LockResult, SessionOwnershipSupport.LockResult> map = new EnumMap<SharedLocalYieldingClusterLockManager.LockResult, SessionOwnershipSupport.LockResult>(SharedLocalYieldingClusterLockManager.LockResult.class);
        map.put(SharedLocalYieldingClusterLockManager.LockResult.ACQUIRED_FROM_CLUSTER, SessionOwnershipSupport.LockResult.ACQUIRED_FROM_CLUSTER);
        map.put(SharedLocalYieldingClusterLockManager.LockResult.ALREADY_HELD, SessionOwnershipSupport.LockResult.ALREADY_HELD);
        map.put(SharedLocalYieldingClusterLockManager.LockResult.NEW_LOCK, SessionOwnershipSupport.LockResult.NEW_LOCK);
        return map;
    }

    public DistributedCacheManager(LocalDistributableSessionManager manager, Cache<?, ?> cache, SharedLocalYieldingClusterLockManager lockManager, SessionAttributeStorage<T> attributeStorage, BatchingManager batchingManager, CacheInvoker invoker, AtomicMapFactory atomicMapFactory) {
        this.manager = manager;
        this.lockManager = lockManager;
        this.cache = cache;
        this.attributeStorage = attributeStorage;
        this.batchingManager = batchingManager;
        this.invoker = invoker;
        this.atomicMapFactory = atomicMapFactory;
        CacheLoaderManagerConfig loaderManagerConfig = this.cache.getConfiguration().getCacheLoaderManagerConfig();
        this.passivationEnabled = loaderManagerConfig != null ? loaderManagerConfig.isPassivation().booleanValue() && !loaderManagerConfig.isShared().booleanValue() : false;
    }

    Cache<String, AtomicMap<Object, Object>> getSessionCache() {
        return this.cache;
    }

    Cache<Address, String> getJvmRouteCache() {
        return this.cache;
    }

    public void start() {
        if (this.cache.getStatus() != ComponentStatus.RUNNING) {
            this.cache.start();
        }
        this.cache.addListener((Object)this);
        if (this.cache.getConfiguration().getCacheMode().isDistributed()) {
            EmbeddedCacheManager container = (EmbeddedCacheManager)this.cache.getCacheManager();
            container.addListener((Object)this);
            this.getJvmRouteCache().putIfAbsent((Object)container.getAddress(), (Object)this.manager.getJvmRoute());
        }
    }

    public void stop() {
        if (this.cache.getConfiguration().getCacheMode().isDistributed()) {
            EmbeddedCacheManager container = (EmbeddedCacheManager)this.cache.getCacheManager();
            this.getJvmRouteCache().remove((Object)container.getAddress());
            container.removeListener((Object)this);
        }
        this.cache.removeListener((Object)this);
        this.cache.stop();
    }

    public BatchingManager getBatchingManager() {
        return this.batchingManager;
    }

    public void sessionCreated(String sessionId) {
    }

    public void storeSessionData(T sessionData) {
        final String sessionId = sessionData.getRealId();
        if (log.isTraceEnabled()) {
            log.trace((Object)("putSession(): putting session " + DistributedCacheManager.mask(sessionId)));
        }
        Operation<AtomicMap<Object, Object>> operation = new Operation<AtomicMap<Object, Object>>(){

            public AtomicMap<Object, Object> invoke(Cache<String, AtomicMap<Object, Object>> cache) {
                return DistributedCacheManager.this.atomicMapFactory.getAtomicMap(cache, (Object)sessionId, true);
            }
        };
        AtomicMap data = (AtomicMap)this.invoker.invoke(this.getSessionCache(), (CacheInvoker.Operation)operation);
        AtomicMapEntry.VERSION.put((AtomicMap<Object, Object>)data, sessionData.getVersion());
        AtomicMapEntry.METADATA.put((AtomicMap<Object, Object>)data, sessionData.getMetadata());
        AtomicMapEntry.TIMESTAMP.put((AtomicMap<Object, Object>)data, sessionData.getTimestamp());
        this.attributeStorage.store((AtomicMap<Object, Object>)data, sessionData);
    }

    public IncomingDistributableSessionData getSessionData(String sessionId, boolean initialLoad) {
        return this.getData(sessionId, true);
    }

    public IncomingDistributableSessionData getSessionData(String sessionId, String dataOwner, boolean includeAttributes) {
        return dataOwner == null ? this.getData(sessionId, includeAttributes) : null;
    }

    private IncomingDistributableSessionData getData(final String sessionId, boolean includeAttributes) {
        Operation<AtomicMap<Object, Object>> operation = new Operation<AtomicMap<Object, Object>>(){

            public AtomicMap<Object, Object> invoke(Cache<String, AtomicMap<Object, Object>> cache) {
                return DistributedCacheManager.this.atomicMapFactory.getAtomicMap(cache, (Object)sessionId, false);
            }
        };
        AtomicMap data = (AtomicMap)this.invoker.invoke(this.getSessionCache(), (CacheInvoker.Operation)operation);
        if (data == null) {
            return null;
        }
        try {
            Integer version = (Integer)AtomicMapEntry.VERSION.get((AtomicMap<Object, Object>)data);
            Long timestamp = (Long)AtomicMapEntry.TIMESTAMP.get((AtomicMap<Object, Object>)data);
            DistributableSessionMetadata metadata = (DistributableSessionMetadata)AtomicMapEntry.METADATA.get((AtomicMap<Object, Object>)data);
            IncomingDistributableSessionDataImpl result = new IncomingDistributableSessionDataImpl(version, timestamp, metadata);
            if (includeAttributes) {
                try {
                    result.setSessionAttributes(this.attributeStorage.load((AtomicMap<Object, Object>)data));
                }
                catch (Exception e) {
                    throw DistributedCacheManager.getRuntimeException("Failed to load session attributes for session: " + DistributedCacheManager.mask(sessionId), e);
                }
            }
            return result;
        }
        catch (Exception e) {
            String message = String.format("Problem accessing session [%s]: %s", DistributedCacheManager.mask(sessionId), e.toString());
            log.warn((Object)message);
            log.debug((Object)message, (Throwable)e);
            this.removeSessionLocal(sessionId);
            return null;
        }
    }

    public void removeSession(String sessionId) {
        this.removeSession(sessionId, false);
    }

    public void removeSessionLocal(String sessionId) {
        this.removeSession(sessionId, true);
    }

    private void removeSession(final String sessionId, final boolean local) {
        Operation<AtomicMap<Object, Object>> operation = new Operation<AtomicMap<Object, Object>>(){

            public AtomicMap<Object, Object> invoke(Cache<String, AtomicMap<Object, Object>> cache) {
                if (local) {
                    cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL});
                }
                return (AtomicMap)cache.remove((Object)sessionId);
            }
        };
        this.invoker.invoke(this.getSessionCache(), (CacheInvoker.Operation)operation);
    }

    public void removeSessionLocal(String sessionId, String dataOwner) {
        if (dataOwner == null) {
            this.removeSession(sessionId, true);
        }
    }

    public void evictSession(final String sessionId) {
        Operation<Void> operation = new Operation<Void>(){

            public Void invoke(Cache<String, AtomicMap<Object, Object>> cache) {
                cache.evict((Object)sessionId);
                return null;
            }
        };
        this.invoker.invoke(this.getSessionCache(), (CacheInvoker.Operation)operation);
    }

    public void evictSession(String sessionId, String dataOwner) {
        if (dataOwner == null) {
            this.evictSession(sessionId);
        }
    }

    public Map<String, String> getSessionIds() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Object key : this.cache.keySet()) {
            if (!(key instanceof String)) continue;
            result.put((String)key, null);
        }
        return result;
    }

    public boolean isPassivationEnabled() {
        return this.passivationEnabled;
    }

    public void setForceSynchronous(boolean forceSynchronous) {
        this.invoker.setForceSynchronous(forceSynchronous);
    }

    public SessionOwnershipSupport getSessionOwnershipSupport() {
        return this.lockManager != null ? this : null;
    }

    public SessionOwnershipSupport.LockResult acquireSessionOwnership(String sessionId, boolean newLock) throws TimeoutException, InterruptedException {
        SessionOwnershipSupport.LockResult result = lockResultMap.get(this.lockManager.lock(this.getSessionLockKey(sessionId), this.lockTimeout, newLock));
        return result != null ? result : SessionOwnershipSupport.LockResult.UNSUPPORTED;
    }

    public void relinquishSessionOwnership(String sessionId, boolean remove) {
        this.lockManager.unlock(this.getSessionLockKey(sessionId), remove);
    }

    private Serializable getSessionLockKey(String sessionId) {
        return this.cache.getName() + "/" + sessionId;
    }

    public boolean isLocal(String realId) {
        DistributionManager manager = this.cache.getAdvancedCache().getDistributionManager();
        return manager != null ? manager.isLocal((Object)realId) : true;
    }

    public String locate(String sessionId) {
        AdvancedCache cache = this.cache.getAdvancedCache();
        DistributionManager manager = cache.getDistributionManager();
        if (manager != null) {
            for (Address address : manager.locate((Object)sessionId)) {
                String jvmRoute = (String)this.getJvmRouteCache().get((Object)address);
                if (jvmRoute == null) continue;
                cache.withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS});
                return jvmRoute;
            }
        }
        return this.manager.getJvmRoute();
    }

    @CacheEntryRemoved
    public void removed(CacheEntryRemovedEvent event) {
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        Object key = event.getKey();
        if (!(key instanceof String)) {
            return;
        }
        this.manager.notifyRemoteInvalidation((String)key);
    }

    @CacheEntryModified
    public void modified(CacheEntryModifiedEvent event) {
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        Object key = event.getKey();
        if (!(key instanceof String)) {
            return;
        }
        String sessionId = (String)key;
        AtomicMap data = (AtomicMap)event.getValue();
        Integer version = (Integer)AtomicMapEntry.VERSION.get((AtomicMap<Object, Object>)data);
        Long timestamp = (Long)AtomicMapEntry.TIMESTAMP.get((AtomicMap<Object, Object>)data);
        DistributableSessionMetadata metadata = (DistributableSessionMetadata)AtomicMapEntry.METADATA.get((AtomicMap<Object, Object>)data);
        if (timestamp == null) {
            log.warn((Object)String.format("No timestamp attribute found in node modification event for session %s", DistributedCacheManager.mask(sessionId)));
            return;
        }
        boolean updated = this.manager.sessionChangedInDistributedCache(sessionId, null, version.intValue(), timestamp.longValue(), metadata);
        if (!updated) {
            log.warn((Object)String.format("Possible concurrency problem: Replicated version id %d is less than or equal to in-memory version for session %s", version, DistributedCacheManager.mask(sessionId)));
        }
    }

    @CacheEntryActivated
    public void activated(CacheEntryActivatedEvent event) {
        if (event.isPre()) {
            return;
        }
        Object key = event.getKey();
        if (!(key instanceof String)) {
            return;
        }
        if (this.manager.isPassivationEnabled()) {
            this.manager.sessionActivated();
        }
    }

    @ViewChanged
    public void viewChanged(ViewChangedEvent event) {
        List oldMembers = event.getOldMembers();
        List newMembers = event.getNewMembers();
        for (Address member : oldMembers) {
            if (newMembers.contains(member)) continue;
            this.getJvmRouteCache().remove((Object)member);
        }
        Address localAddress = event.getLocalAddress();
        if (!oldMembers.contains(localAddress) && newMembers.contains(localAddress)) {
            this.getJvmRouteCache().put((Object)localAddress, (Object)this.manager.getJvmRoute());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Operation<R>
    extends CacheInvoker.Operation<String, AtomicMap<Object, Object>, R> {
    }
}

