package org.jboss.ha.framework.server.ispn;

import java.util.Properties;

import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.ha.ispn.CacheContainerRegistry;
import org.jgroups.ChannelFactory;

@SuppressWarnings("deprecation")
public class HAPartitionCacheHandler implements CacheContainerSource, org.jboss.ha.framework.server.spi.HAPartitionCacheHandler
{
   private final CacheContainerRegistry registry;
   
   private volatile String cacheContainerName;
   
   public HAPartitionCacheHandler(CacheContainerRegistry registry)
   {
      this.registry = registry;
   }
   
   /**
    * {@inheritDoc}
    * @see org.jboss.ha.framework.server.spi.HAPartitionCacheHandler#acquireCache()
    */
   @Override
   public void acquireCache()
   {
      // No-op
   }

   /**
    * {@inheritDoc}
    * @see org.jboss.ha.framework.server.spi.HAPartitionCacheHandler#startCache()
    */
   @Override
   public void startCache()
   {
      // No-op
   }

   /**
    * {@inheritDoc}
    * @see org.jboss.ha.framework.server.spi.HAPartitionCacheHandler#releaseCache()
    */
   @Override
   public void releaseCache()
   {
      // No-op
   }

   /**
    * {@inheritDoc}
    * @see org.jboss.ha.framework.server.ispn.CacheContainerSource#getCacheContainer()
    */
   @Override
   public CacheContainer getCacheContainer()
   {
      return this.getCacheManager();
   }

   private EmbeddedCacheManager getCacheManager()
   {
      return this.registry.getCacheContainer(this.cacheContainerName);
   }
   
   /**
    * {@inheritDoc}
    * @see org.jboss.ha.framework.server.spi.HAPartitionCacheHandler#getChannelStackName()
    */
   @Override
   public String getChannelStackName()
   {
      return this.getTransportProperties().getProperty("stack");
   }

   /**
    * {@inheritDoc}
    * @see org.jboss.ha.framework.server.spi.HAPartitionCacheHandler#getCacheChannelFactory()
    */
   @Override
   public ChannelFactory getCacheChannelFactory()
   {
      return (ChannelFactory) this.getTransportProperties().get("channelFactory");
   }
   
   private Properties getTransportProperties()
   {
      return this.getCacheManager().getGlobalConfiguration().getTransportProperties();
   }
   
   /**
    * {@inheritDoc}
    * @see org.jboss.ha.framework.server.spi.HAPartitionCacheHandler#getCacheConfigName()
    */
   @Override
   public String getCacheConfigName()
   {
      return this.cacheContainerName;
   }
   
   public void setCacheContainerName(String cacheContainerName)
   {
      this.cacheContainerName = cacheContainerName;
   }
}
