/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.ispn;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jboss.ha.core.framework.server.CoreGroupCommunicationService;
import org.jboss.ha.framework.interfaces.GroupMembershipNotifier;
import org.jboss.ha.framework.interfaces.GroupRpcDispatcher;
import org.jboss.ha.framework.server.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.LockManagerSource;
import org.jgroups.Channel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLockManagerSource
implements LockManagerSource {
    public static final Short SCOPE_ID = 222;
    public static final String SERVICE_NAME = "HTTPSESSIONOWNER";
    private final Map<String, SharedLocalYieldingClusterLockManager> lockManagers = new HashMap<String, SharedLocalYieldingClusterLockManager>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedLocalYieldingClusterLockManager getLockManager(Cache<?, ?> cache) {
        if (!cache.getConfiguration().getCacheMode().isClustered()) {
            return null;
        }
        EmbeddedCacheManager container = (EmbeddedCacheManager)cache.getCacheManager();
        String clusterName = container.getGlobalConfiguration().getClusterName();
        Map<String, SharedLocalYieldingClusterLockManager> map = this.lockManagers;
        synchronized (map) {
            SharedLocalYieldingClusterLockManager lockManager = this.lockManagers.get(clusterName);
            if (lockManager == null) {
                JGroupsTransport transport = (JGroupsTransport)cache.getAdvancedCache().getRpcManager().getTransport();
                Channel channel = transport.getChannel();
                CoreGroupCommunicationService gcs = new CoreGroupCommunicationService();
                gcs.setChannel(channel);
                gcs.setScopeId(SCOPE_ID);
                try {
                    gcs.start();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unexpected exception while starting group communication service for " + clusterName);
                }
                lockManager = new SharedLocalYieldingClusterLockManager(SERVICE_NAME, (GroupRpcDispatcher)gcs, (GroupMembershipNotifier)gcs);
                try {
                    lockManager.start();
                }
                catch (Exception e) {
                    gcs.stop();
                    throw new IllegalStateException("Unexpected exception while starting lock manager for " + clusterName);
                }
                this.lockManagers.put(clusterName, lockManager);
            }
            return lockManager;
        }
    }
}

