/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server.ispn;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.Cache;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.ha.framework.server.ispn.InfinispanHAPartitionCacheHandler;
import org.jboss.ha.ispn.CacheContainerRegistry;
import org.jgroups.ChannelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HAPartitionCacheHandler<K, V>
implements InfinispanHAPartitionCacheHandler<K, V> {
    private final CacheContainerRegistry registry;
    private final AtomicReference<Cache<K, V>> cacheReference = new AtomicReference();
    private final AtomicInteger acquireCount = new AtomicInteger();
    private volatile String cacheContainerName;
    private volatile String cacheName;

    public HAPartitionCacheHandler(CacheContainerRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Cache<K, V> getCache() {
        return this.cacheReference.get();
    }

    public void acquireCache() {
        if (this.cacheReference.get() == null) {
            CacheContainer container = this.registry.getCacheContainer(this.cacheContainerName);
            String name = this.cacheName;
            this.cacheReference.compareAndSet(null, name != null ? container.getCache(name) : container.getCache());
        }
        this.acquireCount.incrementAndGet();
    }

    public void startCache() {
        Cache<K, V> cache = this.cacheReference.get();
        if (cache == null) {
            throw new IllegalStateException("You must first acquire a cache before starting it.");
        }
        if (cache.getStatus() != ComponentStatus.RUNNING) {
            cache.start();
        }
    }

    public void releaseCache() {
        int count = this.acquireCount.decrementAndGet();
        if (count == 0) {
            Cache cache = this.cacheReference.getAndSet(null);
            if (cache != null && cache.getStatus() == ComponentStatus.RUNNING) {
                cache.stop();
            }
        } else if (count < 0) {
            this.acquireCount.compareAndSet(count, count + 1);
            throw new IllegalStateException("Attempt to release cache that was not acquired.");
        }
    }

    public String getChannelStackName() {
        return this.getTransportProperties().getProperty("stack");
    }

    public ChannelFactory getCacheChannelFactory() {
        return (ChannelFactory)this.getTransportProperties().get("channelFactory");
    }

    private Properties getTransportProperties() {
        Cache<K, V> cache = this.cacheReference.get();
        if (cache == null) {
            throw new IllegalStateException("Must acquire cache before getting channel stack name");
        }
        CacheContainer container = cache.getCacheManager();
        if (!(container instanceof EmbeddedCacheManager)) {
            throw new IllegalStateException(String.format("Cache container [%s] is not of the expected type: %s", container.getClass().getName(), EmbeddedCacheManager.class.getName()));
        }
        EmbeddedCacheManager manager = (EmbeddedCacheManager)container;
        return manager.getGlobalConfiguration().getTransportProperties();
    }

    public String getCacheConfigName() {
        return this.cacheName;
    }

    public void setCacheConfigName(String cacheName) {
        this.cacheName = cacheName;
    }

    public String getCacheContainerName() {
        return this.cacheContainerName;
    }

    public void setCacheContainerName(String cacheContainerName) {
        this.cacheContainerName = cacheContainerName;
    }
}

