/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.web.tomcat.service.session.distributedcache.ispn;

import java.util.Map;

import org.infinispan.atomic.AtomicMap;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingSessionGranularitySessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.SessionAttributeMarshaller;

/**
 * Handles session attribute load/store operations for {@link ReplicationGranularity#SESSION} distributed session managers.
 * @author Paul Ferraro
 */
public class CoarseSessionAttributeStorage implements SessionAttributeStorage<OutgoingSessionGranularitySessionData>
{
   private final SessionAttributeMarshaller marshaller;
   
   public CoarseSessionAttributeStorage(SessionAttributeMarshaller marshaller)
   {
      this.marshaller = marshaller;
   }
   
   /**
    * {@inheritDoc}
    * @see org.jboss.web.tomcat.service.session.distributedcache.ispn.SessionAttributeStorage#store(org.infinispan.atomic.AtomicMap, org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingDistributableSessionData)
    */
   @Override
   public void store(AtomicMap<Object, Object> data, OutgoingSessionGranularitySessionData sessionData)
   {
      Map<String, Object> attributes = sessionData.getSessionAttributes();
      
      if (attributes != null)
      {
         AtomicMapEntry.ATTRIBUTES.put(data, this.marshaller.marshal(attributes));
      }
   }

   /**
    * {@inheritDoc}
    * @see org.jboss.web.tomcat.service.session.distributedcache.ispn.SessionAttributeStorage#load(org.infinispan.atomic.AtomicMap)
    */
   @SuppressWarnings("unchecked")
   @Override
   public Map<String, Object> load(AtomicMap<Object, Object> data) throws Exception
   {
      return (Map<String, Object>) this.marshaller.unmarshal(AtomicMapEntry.ATTRIBUTES.get(data));
   }
}
