/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.ispn;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.atomic.AtomicMap;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.SessionAttributeStorage;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingAttributeGranularitySessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.SessionAttributeMarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FineSessionAttributeStorage
implements SessionAttributeStorage<OutgoingAttributeGranularitySessionData> {
    private final SessionAttributeMarshaller marshaller;

    public FineSessionAttributeStorage(SessionAttributeMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public void store(AtomicMap<Object, Object> data, OutgoingAttributeGranularitySessionData sessionData) {
        Set removed;
        Map modified = sessionData.getModifiedSessionAttributes();
        if (modified != null) {
            for (Map.Entry entry : modified.entrySet()) {
                data.put(entry.getKey(), this.marshaller.marshal(entry.getValue()));
            }
        }
        if ((removed = sessionData.getRemovedSessionAttributes()) != null) {
            for (String attribute : removed) {
                data.remove((Object)attribute);
            }
        }
    }

    @Override
    public Map<String, Object> load(AtomicMap<Object, Object> data) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : data.entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof String)) continue;
            String attribute = (String)key;
            try {
                map.put(attribute, this.marshaller.unmarshal(entry.getValue()));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Exception("Failed to unmarshal session attribute: " + attribute, e);
            }
        }
        return map;
    }
}

