/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.ispn;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jboss.ha.core.framework.server.CoreGroupCommunicationService;
import org.jboss.ha.framework.interfaces.GroupMembershipNotifier;
import org.jboss.ha.framework.interfaces.GroupRpcDispatcher;
import org.jboss.ha.framework.server.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.LockManagerSource;
import org.jgroups.Channel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Listener(sync=false)
public class DefaultLockManagerSource
implements LockManagerSource {
    public static final Short SCOPE_ID = 222;
    public static final String SERVICE_NAME = "HTTPSESSIONOWNER";
    private static final Logger log = Logger.getLogger(DefaultLockManagerSource.class);
    private static final Map<String, LockManagerEntry> lockManagers = new HashMap<String, LockManagerEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedLocalYieldingClusterLockManager getLockManager(Cache<?, ?> cache) {
        if (!cache.getConfiguration().getCacheMode().isClustered()) {
            return null;
        }
        JGroupsTransport transport = (JGroupsTransport)cache.getAdvancedCache().getRpcManager().getTransport();
        Channel channel = transport.getChannel();
        String channelName = channel.getName();
        Map<String, LockManagerEntry> map = lockManagers;
        synchronized (map) {
            LockManagerEntry entry = lockManagers.get(channelName);
            if (entry == null) {
                DefaultLockManagerSource.trace("Starting lock manager for cluster %s", channelName);
                entry = new LockManagerEntry(channel);
                EmbeddedCacheManager container = (EmbeddedCacheManager)cache.getCacheManager();
                container.addListener((Object)this);
                lockManagers.put(channelName, entry);
            }
            DefaultLockManagerSource.trace("Registering %s with lock manager for cluster %s", cache.getName(), channelName);
            entry.addCache(cache.getName());
            return entry.getLockManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CacheStopped
    public void stopped(CacheStoppedEvent event) {
        String clusterName = event.getCacheManager().getGlobalConfiguration().getClusterName();
        Map<String, LockManagerEntry> map = lockManagers;
        synchronized (map) {
            LockManagerEntry entry = lockManagers.get(clusterName);
            if (entry != null) {
                DefaultLockManagerSource.trace("Deregistering %s from lock manager for cluster %s", event.getCacheName(), clusterName);
                if (entry.removeCache(event.getCacheName())) {
                    DefaultLockManagerSource.trace("Stopped lock manager for cluster %s", clusterName);
                    lockManagers.remove(clusterName);
                }
            }
        }
    }

    private static void trace(String message, Object ... args) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format(message, args));
        }
    }

    private static class LockManagerEntry {
        private SharedLocalYieldingClusterLockManager lockManager;
        private CoreGroupCommunicationService service;
        private Set<String> caches = new HashSet<String>();

        LockManagerEntry(Channel channel) {
            this.service = new CoreGroupCommunicationService();
            this.service.setChannel(channel);
            this.service.setScopeId(SCOPE_ID);
            try {
                this.service.start();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected exception while starting group communication service for " + channel.getClusterName());
            }
            this.lockManager = new SharedLocalYieldingClusterLockManager(DefaultLockManagerSource.SERVICE_NAME, (GroupRpcDispatcher)this.service, (GroupMembershipNotifier)this.service);
            try {
                this.lockManager.start();
            }
            catch (Exception e) {
                this.service.stop();
                throw new IllegalStateException("Unexpected exception while starting lock manager for " + channel.getClusterName());
            }
        }

        SharedLocalYieldingClusterLockManager getLockManager() {
            return this.lockManager;
        }

        synchronized void addCache(String cacheName) {
            this.caches.add(cacheName);
        }

        synchronized boolean removeCache(String cacheName) {
            this.caches.remove(cacheName);
            boolean empty = this.caches.isEmpty();
            if (empty) {
                try {
                    this.lockManager.stop();
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
                try {
                    this.service.stop();
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            return empty;
        }
    }
}

