/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.ispn;

import java.util.Map;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.jboss.ha.framework.server.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.ha.ispn.DefaultCacheContainerRegistry;
import org.jboss.ha.ispn.atomic.AtomicMapCache;
import org.jboss.ha.ispn.invoker.CacheInvoker;
import org.jboss.ha.ispn.invoker.RetryingCacheInvoker;
import org.jboss.web.tomcat.service.session.distributedcache.impl.BatchingManagerImpl;
import org.jboss.web.tomcat.service.session.distributedcache.impl.SessionAttributeMarshallerFactoryImpl;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.CacheSource;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.DefaultCacheSource;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.DefaultLockManagerSource;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.DistributedCacheManager;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.LockManagerSource;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.SessionAttributeStorage;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.SessionAttributeStorageFactory;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.SessionAttributeStorageFactoryImpl;
import org.jboss.web.tomcat.service.session.distributedcache.spi.BatchingManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingDistributableSessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.SessionAttributeMarshaller;
import org.jboss.web.tomcat.service.session.distributedcache.spi.SessionAttributeMarshallerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedCacheManagerFactory
implements org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManagerFactory {
    private CacheSource cacheSource = new DefaultCacheSource(DefaultCacheContainerRegistry.getInstance());
    private LockManagerSource lockManagerSource = new DefaultLockManagerSource();
    private SessionAttributeStorageFactory storageFactory = new SessionAttributeStorageFactoryImpl();
    private SessionAttributeMarshallerFactory marshallerFactory = new SessionAttributeMarshallerFactoryImpl();
    private CacheInvoker invoker = new RetryingCacheInvoker(new int[]{10, 100});

    public <T extends OutgoingDistributableSessionData> org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManager<T> getDistributedCacheManager(LocalDistributableSessionManager manager) {
        AtomicMapCache sessionCache = this.cacheSource.getCache(manager);
        SharedLocalYieldingClusterLockManager lockManager = this.lockManagerSource.getLockManager((Cache<?, ?>)sessionCache);
        TransactionManager tm = sessionCache.getAdvancedCache().getTransactionManager();
        if (!(tm instanceof BatchModeTransactionManager)) {
            throw new IllegalStateException("Unexpected transaction manager type: " + (tm != null ? tm.getClass().getName() : "null"));
        }
        BatchingManagerImpl batchingManager = new BatchingManagerImpl(tm);
        SessionAttributeMarshaller marshaller = this.marshallerFactory.createMarshaller(manager);
        SessionAttributeStorage storage = this.storageFactory.createStorage(manager.getReplicationConfig().getReplicationGranularity(), marshaller);
        sessionCache = new AtomicMapCache(sessionCache);
        return new DistributedCacheManager(manager, (Cache<String, Map<Object, Object>>)sessionCache, null, lockManager, storage, (BatchingManager)batchingManager, this.invoker);
    }

    public void setCacheSource(CacheSource source) {
        this.cacheSource = source;
    }

    public void setLockManagerSource(LockManagerSource source) {
        this.lockManagerSource = source;
    }

    public void setSessionAttributeStorageFactory(SessionAttributeStorageFactory storageFactory) {
        this.storageFactory = storageFactory;
    }

    public void setSessionAttributeMarshallerFactory(SessionAttributeMarshallerFactory marshallerFactory) {
        this.marshallerFactory = marshallerFactory;
    }

    public void setCacheInvoker(CacheInvoker invoker) {
        this.invoker = invoker;
    }
}

