/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.ispn;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jboss.ha.core.framework.server.CoreGroupCommunicationService;
import org.jboss.ha.framework.interfaces.GroupMembershipNotifier;
import org.jboss.ha.framework.interfaces.GroupRpcDispatcher;
import org.jboss.ha.framework.server.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.LockManagerSource;
import org.jgroups.Channel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Listener
public class DefaultLockManagerSource
implements LockManagerSource {
    public static final Short SCOPE_ID = 222;
    public static final String SERVICE_NAME = "HTTPSESSIONOWNER";
    static final Logger log = Logger.getLogger(DefaultLockManagerSource.class);
    private static final Map<CacheContainer, LockManagerEntry> lockManagers = new IdentityHashMap<CacheContainer, LockManagerEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedLocalYieldingClusterLockManager getLockManager(Cache<?, ?> cache) {
        if (!cache.getConfiguration().getCacheMode().isClustered()) {
            return null;
        }
        CacheContainer container = cache.getCacheManager();
        Map<CacheContainer, LockManagerEntry> map = lockManagers;
        synchronized (map) {
            LockManagerEntry entry = lockManagers.get(container);
            if (entry == null) {
                JGroupsTransport transport = (JGroupsTransport)cache.getAdvancedCache().getRpcManager().getTransport();
                entry = new LockManagerEntry(transport.getChannel());
                DefaultLockManagerSource.trace("Started lock manager for cluster %s", entry);
                ((EmbeddedCacheManager)container).addListener((Object)this);
                lockManagers.put(container, entry);
            }
            DefaultLockManagerSource.trace("Registering %s with lock manager for cluster %s", cache, entry);
            entry.addCache(cache.getName());
            return entry.getLockManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CacheStopped
    public void stopped(CacheStoppedEvent event) {
        EmbeddedCacheManager container = event.getCacheManager();
        Map<CacheContainer, LockManagerEntry> map = lockManagers;
        synchronized (map) {
            LockManagerEntry entry = lockManagers.get(container);
            if (entry != null) {
                String cacheName = event.getCacheName();
                DefaultLockManagerSource.trace("Deregistering %s from lock manager for cluster %s", cacheName, entry);
                if (entry.removeCache(cacheName)) {
                    DefaultLockManagerSource.trace("Stopped lock manager for cluster %s", entry);
                    lockManagers.remove(container);
                }
            }
        }
    }

    private static void trace(String message, Object ... args) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format(message, args));
        }
    }

    private static class LockManagerEntry {
        private final SharedLocalYieldingClusterLockManager lockManager;
        private final CoreGroupCommunicationService service;
        private final String channelName;
        private final Set<String> caches = new HashSet<String>();

        LockManagerEntry(Channel channel) {
            this.channelName = channel.getName();
            this.service = new CoreGroupCommunicationService();
            this.service.setChannel(channel);
            this.service.setScopeId(SCOPE_ID);
            try {
                this.service.start();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected exception while starting group communication service for " + channel.getClusterName());
            }
            this.lockManager = new SharedLocalYieldingClusterLockManager(DefaultLockManagerSource.SERVICE_NAME, (GroupRpcDispatcher)this.service, (GroupMembershipNotifier)this.service);
            try {
                this.lockManager.start();
            }
            catch (Exception e) {
                this.service.stop();
                throw new IllegalStateException("Unexpected exception while starting lock manager for " + channel.getClusterName());
            }
        }

        SharedLocalYieldingClusterLockManager getLockManager() {
            return this.lockManager;
        }

        synchronized void addCache(String cacheName) {
            this.caches.add(cacheName);
        }

        synchronized boolean removeCache(String cacheName) {
            this.caches.remove(cacheName);
            boolean empty = this.caches.isEmpty();
            if (empty) {
                try {
                    this.lockManager.stop();
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
                try {
                    this.service.stop();
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            return empty;
        }

        public String toString() {
            return this.channelName;
        }
    }
}

