/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.cachemanager;

import java.security.AccessController;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;
import org.jboss.logging.Logger;
import org.jboss.util.loading.ContextClassLoaderSwitcher;
import org.jgroups.Address;

class CacheManagerManagedCache
implements Cache {
    private static final Logger log = Logger.getLogger(CacheManagerManagedCache.class);
    private final Cache delegate;
    private final ContextClassLoaderSwitcher switcher;

    CacheManagerManagedCache(Cache delegate) {
        assert (delegate != null) : "delegate is null";
        this.delegate = delegate;
        this.switcher = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws CacheException {
        ContextClassLoaderSwitcher.SwitchContext switchContext = this.switcher.getSwitchContext();
        try {
            switchContext.setClassLoader(this.delegate.getClass().getClassLoader());
            this.delegate.create();
        }
        finally {
            switchContext.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws CacheException {
        ContextClassLoaderSwitcher.SwitchContext switchContext = this.switcher.getSwitchContext();
        try {
            switchContext.setClassLoader(this.delegate.getClass().getClassLoader());
            this.delegate.start();
        }
        finally {
            switchContext.reset();
        }
    }

    public void stop() {
        log.warn((Object)"stop() should not be directly called on caches obtained from a CacheManager -- use CacheManager.releaseCache()", (Throwable)new UnsupportedOperationException("stop() is not supported"));
        this.delegate.stop();
    }

    public void destroy() {
        log.warn((Object)"destroy() should not be directly called on caches obtained from a CacheManager -- use CacheManager.releaseCache()", (Throwable)new UnsupportedOperationException("destroy() is not supported"));
        this.delegate.destroy();
    }

    public void addCacheListener(Object arg0) {
        this.delegate.addCacheListener(arg0);
    }

    public void clearData(String arg0) {
        this.delegate.clearData(arg0);
    }

    public void clearData(Fqn arg0) {
        this.delegate.clearData(arg0);
    }

    public void evict(Fqn arg0) {
        this.delegate.evict(arg0);
    }

    public void evict(Fqn arg0, boolean arg1) {
        this.delegate.evict(arg0, arg1);
    }

    public Object get(Fqn arg0, Object arg1) {
        return this.delegate.get(arg0, arg1);
    }

    public Object get(String arg0, Object arg1) {
        return this.delegate.get(arg0, arg1);
    }

    public Set getCacheListeners() {
        return this.delegate.getCacheListeners();
    }

    public CacheStatus getCacheStatus() {
        return this.delegate.getCacheStatus();
    }

    public Configuration getConfiguration() {
        return this.delegate.getConfiguration();
    }

    public Map getData(Fqn arg0) {
        return this.delegate.getData(arg0);
    }

    public InvocationContext getInvocationContext() {
        return this.delegate.getInvocationContext();
    }

    public Set getKeys(String arg0) {
        return this.getKeys(arg0);
    }

    public Set getKeys(Fqn arg0) {
        return this.getKeys(arg0);
    }

    public Address getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    public List getMembers() {
        return this.delegate.getMembers();
    }

    public Node getNode(Fqn arg0) {
        return this.delegate.getNode(arg0);
    }

    public Node getNode(String arg0) {
        return this.delegate.getNode(arg0);
    }

    public Region getRegion(Fqn arg0, boolean arg1) {
        return this.delegate.getRegion(arg0, arg1);
    }

    public Node getRoot() {
        return this.delegate.getRoot();
    }

    public String getVersion() {
        return this.delegate.getVersion();
    }

    public void move(Fqn arg0, Fqn arg1) throws NodeNotExistsException {
        this.delegate.move(arg0, arg1);
    }

    public void move(String arg0, String arg1) throws NodeNotExistsException {
        this.delegate.move(arg0, arg1);
    }

    public void put(Fqn arg0, Map arg1) {
        this.delegate.put(arg0, arg1);
    }

    public void put(String arg0, Map arg1) {
        this.delegate.put(arg0, arg1);
    }

    public Object put(Fqn arg0, Object arg1, Object arg2) {
        return this.delegate.put(arg0, arg1, arg2);
    }

    public Object put(String arg0, Object arg1, Object arg2) {
        return this.delegate.put(arg0, arg1, arg2);
    }

    public void putForExternalRead(Fqn arg0, Object arg1, Object arg2) {
        this.delegate.putForExternalRead(arg0, arg1, arg2);
    }

    public Object remove(Fqn arg0, Object arg1) {
        return this.delegate.remove(arg0, arg1);
    }

    public Object remove(String arg0, Object arg1) {
        return this.delegate.remove(arg0, arg1);
    }

    public void removeCacheListener(Object arg0) {
        this.delegate.removeCacheListener(arg0);
    }

    public boolean removeNode(Fqn arg0) {
        return this.delegate.removeNode(arg0);
    }

    public boolean removeNode(String arg0) {
        return this.delegate.removeNode(arg0);
    }

    public boolean removeRegion(Fqn arg0) {
        return this.delegate.removeRegion(arg0);
    }

    public void setInvocationContext(InvocationContext arg0) {
        this.delegate.setInvocationContext(arg0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CacheManagerManagedCache) {
            CacheManagerManagedCache other = (CacheManagerManagedCache)obj;
            return this.delegate.equals(other.delegate);
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

