/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.NodeRemovedEvent;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.CacheListenerBase;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.JBossCacheWrapper;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionMetadata;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionTimestamp;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;

@org.jboss.cache.notifications.annotation.CacheListener
public class CacheListener
extends CacheListenerBase {
    private static final int POJO_ATTRIBUTE_FQN_INDEX = 4;
    private static final int POJO_KEY_FQN_INDEX = 5;
    private static final int POJO_INTERNAL_FQN_INDEX = 4;
    private static final int POJO_INTERNAL_FQN_SIZE = 5;
    private static Logger log_ = Logger.getLogger(CacheListener.class);
    private boolean fieldBased_;

    CacheListener(JBossCacheWrapper wrapper, LocalDistributableSessionManager manager, String hostname, String webapp, boolean field) {
        super(manager, hostname, webapp);
        this.fieldBased_ = field;
    }

    @NodeRemoved
    public void nodeRemoved(NodeRemovedEvent event) {
        if (event.isPre()) {
            return;
        }
        boolean local = event.isOriginLocal();
        if (!this.fieldBased_ && local) {
            return;
        }
        Fqn fqn = event.getFqn();
        boolean isBuddy = CacheListener.isBuddyFqn(fqn);
        if (!local && CacheListener.isFqnSessionRootSized(fqn, isBuddy) && this.isFqnForOurWebapp(fqn, isBuddy)) {
            String sessId = CacheListener.getIdFromFqn(fqn, isBuddy);
            this.manager_.notifyRemoteInvalidation(sessId);
        } else if (local && !isBuddy && CacheListener.isPossibleInternalPojoFqn(fqn) && this.isFqnForOurWebapp(fqn, isBuddy)) {
            String sessId = CacheListener.getIdFromFqn(fqn, isBuddy);
            this.manager_.notifyLocalAttributeModification(sessId);
        }
    }

    @NodeModified
    public void nodeModified(NodeModifiedEvent event) {
        if (event.isPre()) {
            return;
        }
        boolean local = event.isOriginLocal();
        if (!this.fieldBased_ && local) {
            return;
        }
        Fqn fqn = event.getFqn();
        boolean isBuddy = CacheListener.isBuddyFqn(fqn);
        if (!local && CacheListener.isFqnSessionRootSized(fqn, isBuddy) && this.isFqnForOurWebapp(fqn, isBuddy)) {
            Map data = event.getData();
            Integer version = (Integer)data.get("V");
            if (version != null) {
                String owner;
                String realId = CacheListener.getIdFromFqn(fqn, isBuddy);
                boolean updated = this.manager_.sessionChangedInDistributedCache(realId, owner = isBuddy ? CacheListener.getBuddyOwner(fqn) : null, version.intValue(), (DistributableSessionTimestamp)data.get("T"), (DistributableSessionMetadata)data.get("M"));
                if (!updated && !isBuddy) {
                    log_.warn((Object)("Possible concurrency problem: Replicated version id " + version + " is less than or equal to in-memory version for session " + realId));
                }
            } else {
                log_.warn((Object)("No VERSION_KEY attribute found in " + fqn));
            }
        } else if (local && !isBuddy && CacheListener.isPossibleInternalPojoFqn(fqn) && this.isFqnForOurWebapp(fqn, isBuddy)) {
            String sessId = CacheListener.getIdFromFqn(fqn, isBuddy);
            this.manager_.notifyLocalAttributeModification(sessId);
        }
    }

    public static String getPojoKeyFromFqn(Fqn fqn, boolean isBuddy) {
        return (String)fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 5 : 5);
    }

    public static boolean isPossibleInternalPojoFqn(Fqn fqn) {
        return fqn.size() > 5 && !"ATTRIBUTE".equals(fqn.get(4));
    }
}

