/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.ha.framework.server.PojoCacheManager;
import org.jboss.ha.framework.server.PojoCacheManagerLocator;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.JBossCacheService;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.Util;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSession;
import org.jboss.web.tomcat.service.session.distributedcache.spi.FieldBasedDistributedCacheManager;

public class FieldBasedJBossCacheService
extends JBossCacheService
implements FieldBasedDistributedCacheManager {
    private final PojoCache pojoCache_;

    public FieldBasedJBossCacheService(String cacheConfigName) throws ClusteringNotSupportedException {
        this(Util.findPojoCache(cacheConfigName));
    }

    public FieldBasedJBossCacheService(PojoCache cache) {
        super(cache.getCache());
        this.pojoCache_ = cache;
        if (!this.isMarshallingAvailable()) {
            throw new IllegalStateException("replication-granularity value is set to 'FIELD' but is not supported by the cache service configuration. Must set 'useRegionBasedMarshalling' to 'true' in the cache configuration");
        }
    }

    protected boolean isFieldBased() {
        return true;
    }

    private Fqn getFieldFqn(String id, String key) {
        return FieldBasedJBossCacheService.getFieldFqn(this.hostName_, this.webAppPath_, id, key);
    }

    private static void breakKeys(String key, List list) {
        StringTokenizer token = new StringTokenizer(key, "/");
        while (token.hasMoreTokens()) {
            list.add(token.nextToken());
        }
    }

    public static Fqn getFieldFqn(String hostName, String contextPath, String sessionId, String attributeKey) {
        ArrayList<String> list = new ArrayList<String>(6);
        list.add("JSESSION");
        list.add(hostName);
        list.add(contextPath);
        list.add(sessionId);
        list.add("ATTRIBUTE");
        FieldBasedJBossCacheService.breakKeys(attributeKey, list);
        return new Fqn(list);
    }

    public Object setPojo(String realId, String key, Object pojo, DistributableSession session) {
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("setPojo(): session id: " + realId + " key: " + key + " object: " + pojo.toString()));
        }
        if (session.needRegionForSession()) {
            Fqn sessionRegion = this.getSessionFqn(realId);
            this.getCache().getRegion(sessionRegion, true);
            session.createdRegionForSession();
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("Created region for session at " + sessionRegion));
            }
        }
        Fqn fqn = this.getFieldFqn(realId, key);
        try {
            Object object = this.pojoCache_.attach(fqn.toString(), pojo);
            return object;
        }
        catch (CacheException e) {
            throw new RuntimeException("JBossCacheService: exception occurred in cache setPojo ... ", e);
        }
    }

    public Object removePojo(String realId, String key) {
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("removePojo(): session id: " + realId + " key: " + key));
        }
        Fqn fqn = this.getFieldFqn(realId, key);
        try {
            Object object = this.pojoCache_.detach(fqn.toString());
            return object;
        }
        catch (CacheException e) {
            throw new RuntimeException("JBossCacheService: exception occurred in cache removePojo ... ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePojosLocal(String realId) {
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("removePojoLocal(): session id: " + realId));
        }
        Fqn fqn = this.getAttributeFqn(realId);
        this.cacheWrapper_.removeLocal(fqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePojoLocal(String realId, String key) {
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("removePojoLocal(): session id: " + realId + " key: " + key));
        }
        Fqn fqn = this.getFieldFqn(realId, key);
        this.cacheWrapper_.removeLocal(fqn);
    }

    public Set getPojoKeys(String realId) {
        Set keys = null;
        Fqn fqn = this.getAttributeFqn(realId);
        try {
            keys = this.getChildrenNames(fqn);
        }
        catch (CacheException e) {
            log_.error((Object)("getPojoKeys(): Exception getting keys for session " + realId), (Throwable)e);
        }
        return keys;
    }

    public Object getPojo(String realId, String key) {
        Fqn fqn = this.getFieldFqn(realId, key);
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("getPojo(): session id: " + realId + " key: " + key + " fqn: " + fqn));
        }
        try {
            return this.pojoCache_.find(fqn);
        }
        catch (CacheException e) {
            throw new RuntimeException("JBossCacheService: exception occurred in cache find ... ", e);
        }
    }

    protected void releaseCacheToManager(String cacheConfigName) {
        try {
            PojoCacheManager pcm = PojoCacheManagerLocator.getCacheManagerLocator().getCacheManager(null);
            pcm.releaseCache(cacheConfigName);
        }
        catch (Exception e) {
            log_.error((Object)("Problem releasing cache to CacheManager -- config is " + cacheConfigName), (Throwable)e);
        }
    }
}

