/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import java.util.Map;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.SuspectException;
import org.jboss.cache.lock.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheWrapper {
    private static final int RETRY = 3;
    private static final String RETRY_FAIL_MSG = "Continued to catch TimeoutException during 3 retry attempts. Giving up.";
    private Cache<Object, Object> plainCache_;

    JBossCacheWrapper(Cache<Object, Object> cache) {
        this.plainCache_ = cache;
    }

    Map<Object, Object> getData(Fqn<?> fqn, boolean gravitate) {
        Throwable ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                if (gravitate) {
                    this.plainCache_.getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
                }
                return this.plainCache_.getData(fqn);
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
            catch (SuspectException e) {
                ex = e;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    Object get(Fqn<?> fqn, String id) {
        return this.get(fqn, id, false);
    }

    Object get(Fqn<?> fqn, String id, boolean gravitate) {
        Throwable ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                if (gravitate) {
                    this.plainCache_.getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
                }
                return this.plainCache_.get(fqn, (Object)id);
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
            catch (SuspectException e) {
                ex = e;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    void put(Fqn<?> fqn, String id, Object value) {
        Throwable ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.plainCache_.put(fqn, (Object)id, value);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
            catch (SuspectException e) {
                ex = e;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    void put(Fqn<?> fqn, Map<Object, Object> map) {
        Throwable ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.plainCache_.put(fqn, map);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
            catch (SuspectException e) {
                ex = e;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    Object remove(Fqn<?> fqn, String id) {
        Throwable ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.plainCache_.remove(fqn, (Object)id);
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
            catch (SuspectException e) {
                ex = e;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    Object removeLocal(Fqn<?> fqn, String id) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.plainCache_.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                return this.plainCache_.remove(fqn, (Object)id);
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    void remove(Fqn<?> fqn) {
        Throwable ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.plainCache_.removeNode(fqn);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
            catch (SuspectException e) {
                ex = e;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    void removeLocal(Fqn<?> fqn) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.plainCache_.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                this.plainCache_.removeNode(fqn);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    void evictSubtree(Fqn<?> fqn) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.plainCache_.evict(fqn, true);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }
}

