/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.server.DistributedStateImplMBean;
import org.jboss.ha.framework.server.HAPartitionCacheHandlerImpl;
import org.jboss.ha.framework.server.spi.ManagedDistributedState;
import org.jboss.logging.Logger;

@CacheListener
public class DistributedStateImpl
implements ManagedDistributedState,
DistributedStateImplMBean {
    public static final Serializable ROOT = "__DISTRIBUTED_STATE__";
    public static final Fqn<Serializable> ROOTFQN = Fqn.fromElements((Object[])new Serializable[]{ROOT});
    public static final int ROOTFQNSIZE = ROOTFQN.size();
    protected static final String SERVICE_NAME = "DistributedState";
    protected Map<String, List<Object>> keyListeners = new HashMap<String, List<Object>>();
    protected Logger log = Logger.getLogger(this.getClass());
    protected String name = null;
    protected Cache<Serializable, Serializable> cache;
    protected boolean replAsync;
    protected HAPartitionCacheHandlerImpl cacheHandler;
    protected boolean acquiredCache = false;

    public void createService() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startService() throws Exception {
        if (this.cache == null) {
            if (this.cacheHandler == null) {
                throw new IllegalStateException("No clustered cache available");
            }
            Cache<Object, Object> c = null;
            HAPartitionCacheHandlerImpl hAPartitionCacheHandlerImpl = this.cacheHandler;
            synchronized (hAPartitionCacheHandlerImpl) {
                c = this.cacheHandler.getCache();
                if (c == null) {
                    this.cacheHandler.acquireCache();
                    c = this.cacheHandler.getCache();
                    this.acquiredCache = true;
                }
            }
            this.cacheHandler.startCache();
            Cache<Object, Object> unchecked = c;
            this.setClusteredCache(unchecked);
        }
        this.cache.addCacheListener((Object)this);
    }

    public void stopService() throws Exception {
        this.cache.removeCacheListener((Object)this);
        if (this.acquiredCache) {
            this.cacheHandler.releaseCache();
        }
    }

    public void destroyService() throws Exception {
    }

    @Override
    public String listContent() throws Exception {
        StringBuilder result = new StringBuilder();
        Collection<String> cats = this.getAllCategories();
        if (cats == null) {
            return result.toString();
        }
        for (String category : cats) {
            Iterator<Serializable> keysIter = this.getAllKeys(category).iterator();
            result.append("-----------------------------------------------\n");
            result.append("Logger : ").append(category).append("\n\n");
            result.append("KEY\t:\tVALUE\n");
            while (keysIter.hasNext()) {
                Serializable key = keysIter.next();
                String value = this.get(category, key).toString();
                result.append("'").append(key);
                result.append("'\t:\t'");
                result.append(value);
                result.append("'\n");
            }
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    public String listXmlContent() throws Exception {
        StringBuilder result = new StringBuilder();
        result.append("<DistributedState>\n");
        Collection<String> cats = this.getAllCategories();
        if (cats != null) {
            for (String category : cats) {
                Iterator<Serializable> keysIter = this.getAllKeys(category).iterator();
                result.append("\t<Logger>\n");
                result.append("\t\t<LoggerName>").append(category).append("</LoggerName>\n");
                while (keysIter.hasNext()) {
                    Serializable key = keysIter.next();
                    String value = this.get(category, key).toString();
                    result.append("\t\t<Entry>\n");
                    result.append("\t\t\t<Key>").append(key).append("</Key>\n");
                    result.append("\t\t\t<Value>").append(value).append("</Value>\n");
                    result.append("\t\t</Entry>\n");
                }
                result.append("\t</Logger>\n");
            }
        }
        result.append("</DistributedState>\n");
        return result.toString();
    }

    public Cache<Serializable, Serializable> getClusteredCache() {
        return this.cache;
    }

    public void setClusteredCache(Cache<Serializable, Serializable> cache) {
        this.cache = cache;
        if (this.cache != null) {
            Configuration.CacheMode cm = cache.getConfiguration().getCacheMode();
            if (Configuration.CacheMode.REPL_ASYNC == cm) {
                this.replAsync = true;
            } else if (Configuration.CacheMode.REPL_SYNC == cm) {
                this.replAsync = false;
            } else {
                throw new IllegalStateException("Cache must be configured for replication, not " + cm);
            }
            this.acquiredCache = false;
        }
    }

    public HAPartitionCacheHandlerImpl getCacheHandler() {
        return this.cacheHandler;
    }

    public void setCacheHandler(HAPartitionCacheHandlerImpl cacheHandler) {
        this.cacheHandler = cacheHandler;
    }

    public void set(String category, Serializable key, Serializable value) throws Exception {
        this.set(category, key, value, true);
    }

    public void set(String category, Serializable key, Serializable value, boolean asynchronousCall) throws Exception {
        if (this.replAsync != asynchronousCall) {
            if (asynchronousCall) {
                this.cache.getInvocationContext().getOptionOverrides().setForceAsynchronous(true);
            } else {
                this.cache.getInvocationContext().getOptionOverrides().setForceSynchronous(true);
            }
        }
        this.cache.put(this.buildFqn(category), (Object)key, (Object)value);
    }

    public Serializable remove(String category, Serializable key) throws Exception {
        return this.remove(category, key, true);
    }

    public Serializable remove(String category, Serializable key, boolean asynchronousCall) throws Exception {
        Serializable retVal = this.get(category, key);
        if (retVal != null) {
            if (this.replAsync != asynchronousCall) {
                if (asynchronousCall) {
                    this.cache.getInvocationContext().getOptionOverrides().setForceAsynchronous(true);
                } else {
                    this.cache.getInvocationContext().getOptionOverrides().setForceSynchronous(true);
                }
            }
            this.cache.remove(this.buildFqn(category), (Object)key);
        }
        return retVal;
    }

    public Serializable get(String category, Serializable key) {
        try {
            return (Serializable)this.cache.get(this.buildFqn(category), (Object)key);
        }
        catch (CacheException ce) {
            return null;
        }
    }

    public Collection<String> getAllCategories() {
        try {
            Collection<Object> keys;
            Node base = this.cache.getRoot().getChild(ROOTFQN);
            Set set = keys = base == null ? null : base.getChildrenNames();
            if (keys != null && keys.size() > 0) {
                keys = Collections.unmodifiableCollection(keys);
            }
            return keys;
        }
        catch (CacheException ce) {
            return null;
        }
    }

    public Collection<Serializable> getAllKeys(String category) {
        Node<Serializable, Serializable> node;
        block3: {
            try {
                node = this.getNode(category);
                if (node != null) break block3;
                return null;
            }
            catch (CacheException ce) {
                return null;
            }
        }
        return node.getKeys();
    }

    public Collection<Serializable> getAllValues(String category) {
        Map entries;
        block7: {
            Node<Serializable, Serializable> categoryNode;
            block6: {
                block5: {
                    try {
                        categoryNode = this.getNode(category);
                        if (categoryNode != null) break block5;
                        return null;
                    }
                    catch (CacheException ce) {
                        return null;
                    }
                }
                Set childNodes = categoryNode.getKeys();
                if (childNodes != null) break block6;
                return null;
            }
            entries = categoryNode.getData();
            if (entries != null) break block7;
            return null;
        }
        HashSet retVal = new HashSet(entries.values());
        return Collections.unmodifiableCollection(retVal);
    }

    public void registerDSListenerEx(String category, DistributedState.DSListenerEx subscriber) {
        this.registerListener(category, subscriber);
    }

    public void unregisterDSListenerEx(String category, DistributedState.DSListenerEx subscriber) {
        this.unregisterListener(category, subscriber);
    }

    public void registerDSListener(String category, DistributedState.DSListener subscriber) {
        this.registerListener(category, subscriber);
    }

    public void unregisterDSListener(String category, DistributedState.DSListener subscriber) {
        this.unregisterListener(category, subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerListener(String category, Object subscriber) {
        Map<String, List<Object>> map = this.keyListeners;
        synchronized (map) {
            List<Object> listeners = this.keyListeners.get(category);
            if (listeners == null) {
                listeners = new ArrayList<Object>();
                this.keyListeners.put(category, listeners);
            }
            listeners.add(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterListener(String category, Object subscriber) {
        Map<String, List<Object>> map = this.keyListeners;
        synchronized (map) {
            List<Object> listeners = this.keyListeners.get(category);
            if (listeners == null) {
                return;
            }
            listeners.remove(subscriber);
            if (listeners.size() == 0) {
                this.keyListeners.remove(category);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyKeyListeners(String category, Serializable key, Serializable value, boolean locallyModified) {
        Map<String, List<Object>> map = this.keyListeners;
        synchronized (map) {
            List<Object> listeners = this.keyListeners.get(category);
            if (listeners == null) {
                return;
            }
            String strKey = key.toString();
            for (Object listener : listeners) {
                DistributedState.DSListener dslistener;
                if (listener instanceof DistributedState.DSListener) {
                    dslistener = (DistributedState.DSListener)listener;
                    dslistener.valueHasChanged(category, strKey, value, locallyModified);
                    continue;
                }
                dslistener = (DistributedState.DSListenerEx)listener;
                dslistener.valueHasChanged(category, key, value, locallyModified);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyKeyListenersOfRemove(String category, Serializable key, Serializable oldContent, boolean locallyModified) {
        Map<String, List<Object>> map = this.keyListeners;
        synchronized (map) {
            List<Object> listeners = this.keyListeners.get(category);
            if (listeners == null) {
                return;
            }
            String strKey = key.toString();
            for (Object listener : listeners) {
                DistributedState.DSListener dslistener;
                if (listener instanceof DistributedState.DSListener) {
                    dslistener = (DistributedState.DSListener)listener;
                    dslistener.keyHasBeenRemoved(category, strKey, oldContent, locallyModified);
                    continue;
                }
                dslistener = (DistributedState.DSListenerEx)listener;
                dslistener.keyHasBeenRemoved(category, key, oldContent, locallyModified);
            }
        }
    }

    protected void cleanupKeyListeners() {
    }

    protected Fqn<Serializable> buildFqn(String category) {
        return Fqn.fromRelativeElements(ROOTFQN, (Object[])new Serializable[]{category});
    }

    protected Fqn<Serializable> buildFqn(String category, Serializable key) {
        return Fqn.fromElements((Object[])new Serializable[]{ROOT, category, key});
    }

    protected Fqn<Serializable> buildFqn(String category, Serializable key, Serializable value) {
        return Fqn.fromElements((Object[])new Serializable[]{ROOT, category, key, value});
    }

    protected Node<Serializable, Serializable> getNode(String category) throws CacheException {
        return this.cache.getRoot().getChild(this.buildFqn(category));
    }

    @NodeModified
    public void nodeModified(NodeModifiedEvent event) {
        if (event.isPre()) {
            return;
        }
        NodeModifiedEvent.ModificationType modType = event.getModificationType();
        if (!modType.equals((Object)NodeModifiedEvent.ModificationType.PUT_DATA) && !modType.equals((Object)NodeModifiedEvent.ModificationType.REMOVE_DATA)) {
            return;
        }
        Fqn fqn = event.getFqn();
        if (!fqn.isChildOf(ROOTFQN)) {
            return;
        }
        Serializable key = null;
        Serializable value = null;
        Map data = event.getData();
        if (data != null && !data.isEmpty()) {
            key = (Serializable)data.keySet().iterator().next();
            value = (Serializable)data.get(key);
        }
        if (modType.equals((Object)NodeModifiedEvent.ModificationType.PUT_DATA)) {
            this.notifyKeyListeners((String)fqn.get(ROOTFQNSIZE), key, value, event.isOriginLocal());
        } else {
            this.notifyKeyListenersOfRemove((String)fqn.get(ROOTFQNSIZE), key, value, event.isOriginLocal());
        }
    }
}

