/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;

public class CacheListenerBase {
    private static final int WEBAPP_FQN_INDEX = 1;
    protected static final int SESSION_ID_FQN_INDEX = 2;
    private static final int SESSION_FQN_SIZE = 3;
    private static final int BUDDY_BACKUP_ROOT_OWNER_INDEX = BuddyManager.BUDDY_BACKUP_SUBTREE_FQN.size();
    protected static final int BUDDY_BACKUP_ROOT_OWNER_SIZE = BUDDY_BACKUP_ROOT_OWNER_INDEX + 1;
    private static final String DEAD_BUDDY_SUFFIX = ":DEAD";
    private static final String JSESSION = "JSESSION";
    protected LocalDistributableSessionManager manager_;
    private String contextHostPath_;

    CacheListenerBase(LocalDistributableSessionManager manager, String contextHostPath) {
        this.manager_ = manager;
        this.contextHostPath_ = contextHostPath;
    }

    public static final int getJSessionIndex(Fqn<String> fqn, boolean isBuddy) {
        block6: {
            if (isBuddy || !JSESSION.equals(fqn.get(0))) break block6;
            return 0;
        }
        try {
            if (isBuddy) {
                if (JSESSION.equals(fqn.get(BUDDY_BACKUP_ROOT_OWNER_INDEX + 1))) {
                    return BUDDY_BACKUP_ROOT_OWNER_INDEX + 1;
                }
                if (JSESSION.equals(fqn.get(BUDDY_BACKUP_ROOT_OWNER_INDEX + 2))) {
                    return BUDDY_BACKUP_ROOT_OWNER_INDEX + 2;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return -1;
    }

    protected boolean isFqnForOurWebapp(Fqn<String> fqn, int jsessionIndex) {
        try {
            return jsessionIndex > -1 && this.contextHostPath_.equals(fqn.get(jsessionIndex + 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    @Deprecated
    protected boolean isFqnForOurWebapp(Fqn<String> fqn, boolean isBuddy) {
        int index = CacheListenerBase.getJSessionIndex(fqn, isBuddy);
        return this.isFqnForOurWebapp(fqn, index);
    }

    public static boolean isFqnSessionRootSized(Fqn<String> fqn, int jsessionIndex) {
        return fqn.size() == jsessionIndex + 3;
    }

    @Deprecated
    public static boolean isFqnSessionRootSized(Fqn<String> fqn, boolean isBuddy) {
        int index = CacheListenerBase.getJSessionIndex(fqn, isBuddy);
        return isBuddy ? index > 0 && CacheListenerBase.isFqnSessionRootSized(fqn, index) : CacheListenerBase.isFqnSessionRootSized(fqn, index);
    }

    public static String getIdFromFqn(Fqn<String> fqn, int jsessionIndex) {
        return (String)fqn.get(jsessionIndex + 2);
    }

    @Deprecated
    public static String getIdFromFqn(Fqn<String> fqn, boolean isBuddy) {
        int index = CacheListenerBase.getJSessionIndex(fqn, isBuddy);
        return CacheListenerBase.getIdFromFqn(fqn, index);
    }

    public static boolean isBuddyFqn(Fqn<String> fqn) {
        try {
            return "_BUDDY_BACKUP_".equals(fqn.get(0));
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public static String getBuddyOwner(Fqn<String> fqn) {
        String base = (String)fqn.get(BUDDY_BACKUP_ROOT_OWNER_INDEX);
        return base.endsWith(DEAD_BUDDY_SUFFIX) ? base.substring(0, base.length() - DEAD_BUDDY_SUFFIX.length()) : base;
    }
}

