/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import org.jboss.cache.Fqn;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.Util;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;

public class CacheListenerBase {
    private static final int WEBAPP_FQN_INDEX = 1;
    protected static final int SESSION_ID_FQN_INDEX = 2;
    private static final int SESSION_FQN_SIZE = 3;
    protected LocalDistributableSessionManager manager_;
    private String contextHostPath_;

    CacheListenerBase(LocalDistributableSessionManager manager, String contextHostPath) {
        this.manager_ = manager;
        this.contextHostPath_ = contextHostPath;
    }

    protected boolean isFqnForOurWebapp(Fqn<String> fqn, int jsessionIndex) {
        try {
            return jsessionIndex > -1 && this.contextHostPath_.equals(fqn.get(jsessionIndex + 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    @Deprecated
    protected boolean isFqnForOurWebapp(Fqn<String> fqn, boolean isBuddy) {
        int index = Util.getJSessionIndex(fqn, isBuddy);
        return this.isFqnForOurWebapp(fqn, index);
    }

    public static boolean isFqnSessionRootSized(Fqn<String> fqn, int jsessionIndex) {
        return fqn.size() == jsessionIndex + 3;
    }

    @Deprecated
    public static boolean isFqnSessionRootSized(Fqn<String> fqn, boolean isBuddy) {
        int index = Util.getJSessionIndex(fqn, isBuddy);
        return isBuddy ? index > 0 && CacheListenerBase.isFqnSessionRootSized(fqn, index) : CacheListenerBase.isFqnSessionRootSized(fqn, index);
    }

    public static String getIdFromFqn(Fqn<String> fqn, int jsessionIndex) {
        return (String)fqn.get(jsessionIndex + 2);
    }

    @Deprecated
    public static String getIdFromFqn(Fqn<String> fqn, boolean isBuddy) {
        int index = Util.getJSessionIndex(fqn, isBuddy);
        return CacheListenerBase.getIdFromFqn(fqn, index);
    }

    public static boolean isBuddyFqn(Fqn<String> fqn) {
        try {
            return "_BUDDY_BACKUP_".equals(fqn.get(0));
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }
}

