/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheManager;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.ha.framework.server.CacheManagerLocator;
import org.jboss.ha.framework.server.PojoCacheManager;
import org.jboss.ha.framework.server.PojoCacheManagerLocator;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;

public class Util {
    private static final int BUDDY_BACKUP_ROOT_OWNER_INDEX = BuddyManager.BUDDY_BACKUP_SUBTREE_FQN.size();
    private static final String DEAD_BUDDY_SUFFIX = ":DEAD";
    private static final String JSESSION = "JSESSION";

    public static ReplicationGranularity getReplicationGranularity(LocalDistributableSessionManager localManager) {
        ReplicationConfig config = localManager.getReplicationConfig();
        return config.getReplicationGranularity();
    }

    public static String getCacheConfigName(LocalDistributableSessionManager localManager) {
        ReplicationConfig config = localManager.getReplicationConfig();
        return config.getCacheName();
    }

    @Deprecated
    public static PojoCache findPojoCache(String cacheConfigName) throws ClusteringNotSupportedException {
        PojoCacheManager pcm = Util.getManagerForPojoCache(cacheConfigName);
        try {
            return pcm.getPojoCache(cacheConfigName, true);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem accessing cache " + cacheConfigName, e);
        }
    }

    public static PojoCache findPojoCache(String cacheConfigName, PojoCacheManager pcm) {
        if (!pcm.getConfigurationNames().contains(cacheConfigName)) {
            throw new IllegalStateException("PojoCacheManager does not recognize config " + cacheConfigName);
        }
        try {
            return pcm.getPojoCache(cacheConfigName, true);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem accessing cache " + cacheConfigName, e);
        }
    }

    @Deprecated
    public static Cache<Object, Object> findPlainCache(String cacheConfigName) throws ClusteringNotSupportedException {
        CacheManager pcm = Util.getManagerForCache(cacheConfigName);
        try {
            return pcm.getCache(cacheConfigName, true);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem accessing cache " + cacheConfigName, e);
        }
    }

    public static Cache<Object, Object> findPlainCache(String cacheConfigName, CacheManager cm) {
        if (!cm.getConfigurationNames().contains(cacheConfigName)) {
            throw new IllegalStateException("CacheManager does not recognize config " + cacheConfigName);
        }
        try {
            return cm.getCache(cacheConfigName, true);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem accessing cache " + cacheConfigName, e);
        }
    }

    public static PojoCacheManager findPojoCacheManager() throws ClusteringNotSupportedException {
        try {
            return PojoCacheManagerLocator.getCacheManagerLocator().getCacheManager(null);
        }
        catch (Throwable t) {
            throw new ClusteringNotSupportedException("Could not access CacheManager for JBossWeb clustering", t);
        }
    }

    public static CacheManager findPlainCacheManager() throws ClusteringNotSupportedException {
        try {
            return CacheManagerLocator.getCacheManagerLocator().getCacheManager(null);
        }
        catch (Throwable t) {
            throw new ClusteringNotSupportedException("Could not access CacheManager for JBossWeb clustering", t);
        }
    }

    private static PojoCacheManager getManagerForPojoCache(String cacheConfigName) throws ClusteringNotSupportedException {
        PojoCacheManager pcm = null;
        try {
            pcm = PojoCacheManagerLocator.getCacheManagerLocator().getCacheManager(null);
        }
        catch (Throwable t) {
            throw new ClusteringNotSupportedException("Could not access PojoCacheManager for JBossWeb clustering", t);
        }
        if (!pcm.getConfigurationNames().contains(cacheConfigName)) {
            throw new IllegalStateException("PojoCacheManager does not recognize config " + cacheConfigName);
        }
        return pcm;
    }

    private static CacheManager getManagerForCache(String cacheConfigName) throws ClusteringNotSupportedException {
        CacheManager cm = null;
        try {
            cm = CacheManagerLocator.getCacheManagerLocator().getCacheManager(null);
        }
        catch (Throwable t) {
            throw new ClusteringNotSupportedException("Could not access CacheManager for JBossWeb clustering", t);
        }
        if (!cm.getConfigurationNames().contains(cacheConfigName)) {
            throw new IllegalStateException("CacheManager does not recognize config " + cacheConfigName);
        }
        return cm;
    }

    public static String maskId(String realId) {
        if (realId == null) {
            return null;
        }
        int length = realId.length();
        if (length <= 8) {
            return realId;
        }
        StringBuilder sb = new StringBuilder(realId.substring(0, 2));
        sb.append("****");
        sb.append(realId.substring(length - 6, length));
        return sb.toString();
    }

    public static final int getJSessionIndex(Fqn<String> fqn, boolean isBuddy) {
        try {
            if (!isBuddy && JSESSION.equals(fqn.get(0))) {
                return 0;
            }
            if (isBuddy) {
                if (JSESSION.equals(fqn.get(BUDDY_BACKUP_ROOT_OWNER_INDEX + 1))) {
                    return BUDDY_BACKUP_ROOT_OWNER_INDEX + 1;
                }
                if (JSESSION.equals(fqn.get(BUDDY_BACKUP_ROOT_OWNER_INDEX + 2))) {
                    return BUDDY_BACKUP_ROOT_OWNER_INDEX + 2;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return -1;
    }

    public static boolean isBuddyOwnerDead(Fqn<String> fqn) {
        String base = (String)fqn.get(BUDDY_BACKUP_ROOT_OWNER_INDEX);
        return base.endsWith(DEAD_BUDDY_SUFFIX);
    }

    public static String getBuddyOwner(Fqn<String> fqn) {
        String base = (String)fqn.get(BUDDY_BACKUP_ROOT_OWNER_INDEX);
        return base.endsWith(DEAD_BUDDY_SUFFIX) ? base.substring(0, base.length() - DEAD_BUDDY_SUFFIX.length()) : base;
    }

    private Util() {
    }
}

