/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.cachemanager;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationRegistry;
import org.jboss.ha.cachemanager.CacheConfigsParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyInjectedConfigurationRegistry
implements ConfigurationRegistry {
    private CacheConfigsParser parser = new CacheConfigsParser();
    private String configResource;
    private Map<String, Configuration> configs = new Hashtable<String, Configuration>();
    private boolean started;

    public void start() throws Exception {
        if (!this.started) {
            this.loadConfigResource(this.configResource);
            this.started = true;
        }
    }

    private void loadConfigResource(String resource) throws CloneNotSupportedException {
        if (resource != null) {
            Map parsed = this.parser.parseConfigs(resource);
            for (Map.Entry entry : parsed.entrySet()) {
                this.registerConfiguration((String)entry.getKey(), (Configuration)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.started) {
            Map<String, Configuration> map = this.configs;
            synchronized (map) {
                this.configs.clear();
            }
            this.started = false;
        }
    }

    public void setConfigResource(String resource) {
        if (this.started) {
            try {
                this.loadConfigResource(resource);
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Configuration in " + resource + " does not properly support cloning", e);
            }
        } else {
            this.configResource = resource;
        }
    }

    public void setNewConfigurations(Map<String, Configuration> newConfigs) {
        if (newConfigs != null) {
            for (Map.Entry<String, Configuration> entry : newConfigs.entrySet()) {
                try {
                    this.registerConfiguration(entry.getKey(), entry.getValue());
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException("Configuration " + entry.getKey() + " does not properly support cloning", e);
                }
            }
        }
    }

    public Set<String> getConfigurationNames() {
        return new HashSet<String>(this.configs.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConfiguration(String configName, Configuration config) throws CloneNotSupportedException {
        Map<String, Configuration> map = this.configs;
        synchronized (map) {
            if (this.configs.containsKey(configName)) {
                throw new IllegalStateException(String.valueOf(configName) + " already registered");
            }
            this.configs.put(configName, config.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConfiguration(String configName) {
        Map<String, Configuration> map = this.configs;
        synchronized (map) {
            if (this.configs.remove(configName) == null) {
                throw new IllegalStateException(String.valueOf(configName) + " not registered");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConfiguration(String configName) {
        Configuration config = null;
        Map<String, Configuration> map = this.configs;
        synchronized (map) {
            config = this.configs.get(configName);
        }
        if (config == null) {
            throw new IllegalArgumentException("unknown config " + configName);
        }
        try {
            return config.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Could not clone configuration " + configName, e);
        }
    }
}

