/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.ha.framework.server.PojoCacheManager;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.AbstractJBossCacheService;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.Util;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingDistributableSessionData;

public class FieldBasedJBossCacheService
extends AbstractJBossCacheService<OutgoingDistributableSessionData> {
    public static final String ATTRIBUTE = "ATTRIBUTE";
    private PojoCacheManager pojoCacheManager_;
    private PojoCache pojoCache_;

    public static Fqn<String> getAttributeFqn(String contextHostPath, String sessionId) {
        return Fqn.fromElements((Object[])new String[]{"JSESSION", contextHostPath, sessionId, ATTRIBUTE});
    }

    public static Fqn<String> getFieldFqn(String contextHostPath, String sessionId, String attributeKey) {
        StringTokenizer token = new StringTokenizer(attributeKey, "/");
        int count = token.countTokens();
        if (count == 1) {
            return Fqn.fromElements((Object[])new String[]{"JSESSION", contextHostPath, sessionId, ATTRIBUTE, attributeKey});
        }
        Object[] args = new String[4 + count];
        args[0] = "JSESSION";
        args[1] = contextHostPath;
        args[2] = sessionId;
        args[3] = ATTRIBUTE;
        for (int i = 0; i < count; ++i) {
            args[4 + i] = token.nextToken();
        }
        return Fqn.fromElements((Object[])args);
    }

    public FieldBasedJBossCacheService(LocalDistributableSessionManager localManager) throws ClusteringNotSupportedException {
        super(localManager);
    }

    public FieldBasedJBossCacheService(LocalDistributableSessionManager localManager, PojoCache cache) {
        super(localManager, (Cache<Object, Object>)cache.getCache());
        this.pojoCache_ = cache;
    }

    public boolean getSupportsAttributeOperations() {
        return true;
    }

    public void putAttribute(String realId, String key, Object value) {
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("putAttribute(): session id: " + Util.maskId(realId) + " key: " + key + " object: " + value.toString()));
        }
        Fqn<String> fqn = FieldBasedJBossCacheService.getFieldFqn(this.combinedPath_, realId, key);
        try {
            this.pojoCache_.attach(fqn.toString(), value);
        }
        catch (CacheException e) {
            throw new RuntimeException("Exception occurred in PojoCache attach for session + " + Util.maskId(realId) + " key" + key, e);
        }
    }

    public Object removeAttribute(String realId, String key) {
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("removeAttribute(): session id: " + Util.maskId(realId) + " key: " + key));
        }
        Fqn<String> fqn = FieldBasedJBossCacheService.getFieldFqn(this.combinedPath_, realId, key);
        try {
            return this.pojoCache_.detach(fqn.toString());
        }
        catch (CacheException e) {
            throw new RuntimeException("Exception occurred in PojoCache detach ... ", e);
        }
    }

    public void removeAttributeLocal(String realId, String key) {
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("removeAttributeLocal(): session id: " + Util.maskId(realId) + " key: " + key));
        }
        Fqn<String> fqn = FieldBasedJBossCacheService.getFieldFqn(this.combinedPath_, realId, key);
        this.cacheWrapper_.removeLocal(fqn);
    }

    public Set<String> getAttributeKeys(String realId) {
        Set<String> keys = null;
        Fqn<String> fqn = FieldBasedJBossCacheService.getAttributeFqn(this.combinedPath_, realId);
        try {
            keys = this.getChildrenNames(fqn);
        }
        catch (CacheException e) {
            this.log_.error((Object)("getAttributeKeys(): Exception getting keys for session " + Util.maskId(realId)), (Throwable)e);
        }
        return keys;
    }

    public Object getAttribute(String realId, String key) {
        Fqn<String> fqn = FieldBasedJBossCacheService.getFieldFqn(this.combinedPath_, realId, key);
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("getAttribute(): session id: " + Util.maskId(realId) + " key: " + key + " parent fqn: " + fqn.getParent()));
        }
        try {
            return this.pojoCache_.find(fqn);
        }
        catch (CacheException e) {
            throw new RuntimeException("Exception occurred in PojoCache find ... ", e);
        }
    }

    @Override
    public void sessionCreated(String realId) {
        Fqn<String> fqn = FieldBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        this.setupSessionRegion(fqn);
    }

    @Override
    protected void establishCacheManager() throws ClusteringNotSupportedException {
        this.pojoCacheManager_ = Util.findPojoCacheManager();
    }

    @Override
    protected void obtainCacheFromManager() {
        if (this.pojoCacheManager_ == null) {
            throw new IllegalStateException("No PojoCacheManager available");
        }
        if (this.cacheConfigName_ == null) {
            throw new IllegalStateException("No cache configuration name available");
        }
        this.pojoCache_ = Util.findPojoCache(this.cacheConfigName_, this.pojoCacheManager_);
        this.plainCache_ = this.pojoCache_.getCache();
    }

    @Override
    protected void establishCache() {
        super.establishCache();
        if (!this.isMarshallingAvailable()) {
            throw new IllegalStateException("replication-granularity value is set to 'FIELD' but is not supported by the cache service configuration. Must set 'useRegionBasedMarshalling' to 'true' in the cache configuration");
        }
    }

    @Override
    protected void setupSessionRegion(Fqn<String> fqn) {
        this.getCache().getRegion(fqn, true);
        if (this.log_.isTraceEnabled()) {
            String id = Util.maskId(fqn.getLastElementAsString());
            this.log_.trace((Object)("Created region for session " + id + " under parent fqn " + fqn.getParent()));
        }
    }

    @Override
    protected void removeSessionRegion(String realId, Fqn<String> fqn) {
        this.getCache().removeRegion(fqn);
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("Removed region for session  + " + Util.maskId(realId) + " under parent fqn " + fqn.getParent()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseCacheToManager(String cacheConfigName) {
        try {
            this.pojoCacheManager_.releaseCache(cacheConfigName);
        }
        catch (Exception e) {
            this.log_.error((Object)("Problem releasing cache to CacheManager -- config is " + cacheConfigName), (Throwable)e);
        }
        finally {
            this.plainCache_ = null;
            this.pojoCache_ = null;
        }
    }

    public Map<String, Object> getAttributes(String realId) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        Set<String> keys = this.getAttributeKeys(realId);
        for (String key : keys) {
            attrs.put(key, this.getAttribute(realId, key));
        }
        return attrs;
    }

    public void putAttribute(String realId, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.putAttribute(realId, entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected Map<String, Object> getSessionAttributes(String realId, Map<Object, Object> distributedCacheData) {
        return this.getAttributes(realId);
    }

    @Override
    protected void storeSessionAttributes(Map<Object, Object> dataMap, OutgoingDistributableSessionData sessionData) {
    }
}

