/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.jbc;

import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocatorConfig;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.FileCacheLoaderConfig;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.BatchModeTransactionManagerLookup;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.distributedcache.jbc.DistributedCacheManagerFactoryImpl;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingDistributableSessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.TestDistributedCacheManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDistributedCacheManagerFactoryImpl
implements TestDistributedCacheManagerFactory {
    private static final Logger log = Logger.getLogger(TestDistributedCacheManagerFactoryImpl.class);
    private DistributedCacheManagerFactoryImpl delegate = new DistributedCacheManagerFactoryImpl();

    public void configure(boolean local, String passivationDir, boolean totalReplication, boolean marshalling, boolean purgeCacheLoader) {
        Cache pc = TestDistributedCacheManagerFactoryImpl.createCache(local, passivationDir, totalReplication, marshalling, purgeCacheLoader);
        this.delegate.setPlainCache((Cache<Object, Object>)pc);
    }

    public <T extends OutgoingDistributableSessionData> DistributedCacheManager<T> getDistributedCacheManager(LocalDistributableSessionManager localManager) throws ClusteringNotSupportedException {
        return this.delegate.getDistributedCacheManager(localManager);
    }

    public void cleanup(boolean doRemove) {
        Cache<Object, Object> cache = this.delegate.getPlainCache();
        if (cache == null) {
            return;
        }
        if (doRemove && CacheStatus.STARTED.equals((Object)cache.getCacheStatus())) {
            try {
                log.info((Object)("Removing /JSESSION from " + cache.getLocalAddress()));
                cache.removeNode(Fqn.fromString((String)"/JSESSION"));
            }
            catch (Exception e) {
                log.error((Object)("Cache " + cache + ": " + e.getMessage()), (Throwable)e);
            }
        }
        try {
            cache.stop();
            cache.destroy();
        }
        catch (Exception e) {
            log.error((Object)("Cache " + cache + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private static Cache createCache(boolean local, String passivationDir, boolean totalReplication, boolean marshalling, boolean purgeCacheLoader) {
        Configuration cfg = TestDistributedCacheManagerFactoryImpl.getConfiguration(local, passivationDir, totalReplication, marshalling, purgeCacheLoader);
        return DefaultCacheFactory.getInstance().createCache(cfg, true);
    }

    private static Configuration getConfiguration(boolean local, String passivationDir, boolean totalReplication, boolean marshalling, boolean purgeCacheLoader) {
        Configuration config = new Configuration();
        config.setClusterName("Tomcat-TestCluster");
        config.setTransactionManagerLookupClass(BatchModeTransactionManagerLookup.class.getName());
        config.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        config.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        config.setSyncReplTimeout(20000L);
        config.setLockAcquisitionTimeout(15000L);
        config.setCacheMode(local ? Configuration.CacheMode.LOCAL : Configuration.CacheMode.REPL_SYNC);
        config.setUseRegionBasedMarshalling(marshalling);
        config.setInactiveOnStartup(marshalling);
        config.setSerializationExecutorPoolSize(0);
        config.setListenerAsyncPoolSize(0);
        config.setSyncCommitPhase(true);
        config.setSyncRollbackPhase(true);
        if (passivationDir != null) {
            CacheLoaderConfig clc = new CacheLoaderConfig();
            clc.setPassivation(true);
            clc.setShared(false);
            FileCacheLoaderConfig fclc = new FileCacheLoaderConfig();
            fclc.setLocation(passivationDir);
            fclc.setFetchPersistentState(true);
            fclc.setPurgeOnStartup(purgeCacheLoader);
            fclc.setAsync(false);
            fclc.setIgnoreModifications(false);
            ArrayList<FileCacheLoaderConfig> iclcs = new ArrayList<FileCacheLoaderConfig>();
            iclcs.add(fclc);
            clc.setIndividualCacheLoaderConfigs(iclcs);
            config.setCacheLoaderConfig(clc);
        }
        if (!local && !totalReplication) {
            BuddyReplicationConfig brc = new BuddyReplicationConfig();
            brc.setEnabled(true);
            NextMemberBuddyLocatorConfig blc = new NextMemberBuddyLocatorConfig();
            blc.setNumBuddies(1);
            blc.setIgnoreColocatedBuddies(true);
            brc.setBuddyLocatorConfig((BuddyReplicationConfig.BuddyLocatorConfig)blc);
            brc.setBuddyPoolName("default");
            brc.setBuddyCommunicationTimeout(20000);
            brc.setAutoDataGravitation(false);
            brc.setDataGravitationRemoveOnFind(true);
            brc.setDataGravitationSearchBackupTrees(true);
            config.setBuddyReplicationConfig(brc);
        }
        return config;
    }

    public Object getLocalAddress() {
        Cache<Object, Object> pc = this.delegate.getPlainCache();
        return pc == null ? null : pc.getLocalAddress();
    }

    public List<Object> getMembers() {
        Cache<Object, Object> pc = this.delegate.getPlainCache();
        return pc == null ? null : new ArrayList(pc.getMembers());
    }
}

