/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.web.tomcat.service.session.distributedcache.jbc;

import java.util.Map;
import java.util.Set;

import org.jboss.cache.Cache;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingSessionGranularitySessionData;

/**
 * DistributedCacheManager impl for ReplicationGranularity.SESSION.
 */
public class SessionBasedJBossCacheService extends AbstractJBossCacheService<OutgoingSessionGranularitySessionData>
{   
   private static UnsupportedOperationException UNSUPPORTED = 
      new UnsupportedOperationException("Attribute operations not supported " +
            "with ReplicationGranularity " + ReplicationGranularity.SESSION);
      
   public SessionBasedJBossCacheService(LocalDistributableSessionManager localManager) throws ClusteringNotSupportedException
   {
      super(localManager);
   }
   
   public SessionBasedJBossCacheService(LocalDistributableSessionManager localManager, Cache<Object, Object> cache)
   {
      super(localManager, cache);
   }

   public Object getAttribute(String realId, String key)
   {
      throw UNSUPPORTED;
   }

   public void putAttribute(String realId, String key, Object value)
   {
      throw UNSUPPORTED;
   }

   public void putAttribute(String realId, Map<String, Object> map)
   {
      throw UNSUPPORTED;      
   }

   public Object removeAttribute(String realId, String key)
   {
      throw UNSUPPORTED;
   }

   public void removeAttributeLocal(String realId, String key)
   {
      throw UNSUPPORTED;
   }  

   /**
    * Obtain the keys associated with this fqn. Note that it is not the fqn children.
    */
   public Set<String> getAttributeKeys(String realId)
   {
      throw UNSUPPORTED;
   }

   /**
    * Return all attributes associated with this session id.
    * 
    * @param realId the session id with any jvmRoute removed
    * @return the attributes, or any empty Map if none are found.
    */
   public Map<String, Object> getAttributes(String realId)
   {
      throw UNSUPPORTED;
   }

   
   /**
    * Returns the session attributes, possibly using the passed in 
    * <code>distributedCacheData</code> as a source.
    * 
    * <strong>Note:</strong> This operation may alter the contents of the 
    * passed in map. If this is unacceptable, pass in a defensive copy.
    */
   @SuppressWarnings("unchecked")
   protected Map<String, Object> getSessionAttributes(String realId, Map<Object, Object> distributedCacheData)
   {
      try
      {
         return (Map<String, Object>) this.marshaller.unmarshal(distributedCacheData.get(ATTRIBUTE_KEY));
      }
      catch (RuntimeException e)
      {
         throw e;
      }
      catch (Exception e)
      {
         throw new RuntimeException("Caught exception unmarshalling attribute map for session " +  Util.maskId(realId), e);
      }
   }

   @Override
   protected void storeSessionAttributes(Map<Object, Object> dataMap, OutgoingSessionGranularitySessionData sessionData)
   {
      Map<String, Object> attrs = sessionData.getSessionAttributes();
      if (attrs != null)
      {
         dataMap.put(ATTRIBUTE_KEY, this.marshaller.marshal(attrs));
      }
   }

}
