/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat, Inc. and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.web.tomcat.service.session.distributedcache.spi;

/**
 *
 *
 * @author Brian Stansberry
 * 
 * @version $Revision$
 */
public class TestDistributedCacheManagerFactoryFactory
{
   /** 
    * Default name of the class that {@link #getDistributedCacheManagerFactory()} 
    * will try to instantiate if no factory is injected. 
    */
   public static final String DEFAULT_CLASS_NAME = "org.jboss.web.tomcat.service.session.distributedcache.impl.TestDistributedCacheManagerFactoryImpl";
   
   private final DistributedCacheManagerFactoryFactory delegate = DistributedCacheManagerFactoryFactory.getInstance();
   
   private String factoryClassName = DEFAULT_CLASS_NAME;
   
   /**
    * Gets the class name of the factory; either the name of any existing 
    * factory, a class name injected via this property's setter, or
    * {@link #DEFAULT_CLASS_NAME}.
    * 
    * @return the factory class name; will not return <code>null</code>
    */
   public synchronized String getFactoryClassName()
   {
      return factoryClassName;
   }

   /**
    * Allows injection of the factory class name.
    * 
    * @param factoryClassName Fully qualified name of a class that implements 
    *                         {@link DistributedCacheManagerFactory} and exposes
    *                         a public no-arg constructor.
    */
   public synchronized void setFactoryClassName(String factoryClassName)
   {
      this.factoryClassName = factoryClassName == null ? DEFAULT_CLASS_NAME : factoryClassName;
   }

   /**
    * Returns the factory, creating one if necessary by loading
    * {@link #getFactoryClassName() the factory class} and invoking 
    * {@link Class#newInstance()}.
    * 
    * @return the factory. Will not return <code>null</code>.
    * @throws ClusteringNotSupportedException if there is a problem instantiating a factory
    */
   public synchronized TestDistributedCacheManagerFactory getDistributedCacheManagerFactory(boolean local, String passivationDir, 
         boolean totalReplication, boolean marshalling, boolean purgeCacheLoader)
      throws  ClusteringNotSupportedException
   {
      String existingClassName = delegate.getFactoryClassName();
      DistributedCacheManagerFactory existing = null;
      try
      {
         try
         {
            // Set the factory class name to something that won't work
            // if it's used to create a factory, and then get the factory.
            // Effect is we only get a factory if it already existed
            delegate.setFactoryClassName("+++Illegal+++");
            existing = delegate.getDistributedCacheManagerFactory();
            delegate.setDistributedCacheManagerFactory(null);
         }
         catch (Throwable ignored) {}
         
         delegate.setFactoryClassName(factoryClassName);
         TestDistributedCacheManagerFactory fact = (TestDistributedCacheManagerFactory) delegate.getDistributedCacheManagerFactory();
         fact.configure(local, passivationDir, totalReplication, marshalling, purgeCacheLoader);
         return fact;
      }
      finally
      {
         if (existing != null)
         {
            delegate.setDistributedCacheManagerFactory(existing);
         }
         delegate.setFactoryClassName(existingClassName);
      }
   }
}
