/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ha.ispn;

import java.util.Collection;
import java.util.Collections;

import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;

/**
 * Represents an Infinispan cache container configuration.
 * @author Paul Ferraro
 */
public class CacheContainerConfiguration
{
   private final GlobalConfiguration globalConfiguration;
   private final Configuration defaultConfiguration;
   private final Collection<Configuration> namedConfigurations;
   
   public CacheContainerConfiguration(GlobalConfiguration globalConfiguration, Configuration defaultConfiguration)
   {
      this(globalConfiguration, defaultConfiguration, Collections.<Configuration>emptyList());
   }
   
   public CacheContainerConfiguration(GlobalConfiguration globalConfiguration, Configuration defaultConfiguration, Collection<Configuration> namedConfigurations)
   {
      this.globalConfiguration = globalConfiguration;
      this.defaultConfiguration = defaultConfiguration;
      this.namedConfigurations = namedConfigurations;
   }
   
   /**
    * The general configuration shared by all caches.
    * @return a global configuration
    */
   public GlobalConfiguration getGlobalConfiguration()
   {
      return this.globalConfiguration;
   }

   /**
    * The default configuration inherited by any named caches.
    * @return the default cache configuration
    */
   public Configuration getDefaultConfiguration()
   {
      return this.defaultConfiguration;
   }

   /**
    * The name cache configurations.
    * @return a collection of named cache configuration
    */
   public Collection<Configuration> getNamedConfigurations()
   {
      return this.namedConfigurations;
   }
}
