/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ha.ispn.config.xml;

import org.jboss.util.StringPropertyReplacer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

/**
 * @author Paul Ferraro
 *
 */
public class PropertyReplacementFilter extends XMLFilterImpl
{
   public PropertyReplacementFilter()
   {
      super();
   }
   
   public PropertyReplacementFilter(XMLReader parent)
   {
      super(parent);
   }
   
   /**
    * {@inheritDoc}
    * @see org.xml.sax.helpers.XMLFilterImpl#characters(char[], int, int)
    */
   @Override
   public void characters(char[] data, int start, int length) throws SAXException
   {
      char[] value = StringPropertyReplacer.replaceProperties(String.copyValueOf(data, start, length)).toCharArray();
      super.characters(value, 0, value.length);
   }

   /**
    * {@inheritDoc}
    * @see org.xml.sax.helpers.XMLFilterImpl#startElement(java.lang.String, java.lang.String, java.lang.String, org.xml.sax.Attributes)
    */
   @Override
   public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException
   {
      AttributesImpl attributes = (attrs instanceof AttributesImpl) ? (AttributesImpl) attrs : new AttributesImpl(attrs);
      
      int length = attributes.getLength();
      for (int i = 0; i < length; ++i)
      {
         attributes.setValue(i, StringPropertyReplacer.replaceProperties(attributes.getValue(i)));
      }
      
      super.startElement(uri, localName, qName, attributes);
   }
}
