/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ha.ispn.tree;

import org.infinispan.Cache;
import org.infinispan.tree.TreeCache;

/**
 * Default tree cache factory that delegates to a {@link org.infinispan.tree.TreeCacheFactory}.
 * @author Paul Ferraro
 */
public class DefaultTreeCacheFactory implements TreeCacheFactory
{
   private final org.infinispan.tree.TreeCacheFactory factory = new org.infinispan.tree.TreeCacheFactory();

   /**
    * {@inheritDoc}
    * @see org.jboss.ha.ispn.tree.TreeCacheFactory#createTreeCache(org.infinispan.Cache)
    */
   @Override
   public <K, V> TreeCache<K, V> createTreeCache(Cache<K, V> cache)
   {
      return this.factory.createTreeCache(cache);
   }
}
