/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.ispn;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.remoting.transport.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Listener
public class DefaultCacheContainer
implements EmbeddedCacheManager {
    private final EmbeddedCacheManager container;
    private final ConcurrentMap<String, EmbeddedCacheManager> containers = new ConcurrentHashMap<String, EmbeddedCacheManager>();

    public DefaultCacheContainer(EmbeddedCacheManager manager) {
        this.container = manager;
    }

    public <K, V> Cache<K, V> getCache() {
        return this.getCache("___defaultcache", this.container.getDefaultConfiguration());
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, this.container.defineConfiguration(cacheName, new Configuration()));
    }

    private <K, V> Cache<K, V> getCache(String cacheName, Configuration config) {
        if (config.getCacheMode().isDistributed()) {
            GlobalConfiguration globalConfig = this.container.getGlobalConfiguration();
            String clusterName = globalConfig.getClusterName() + "/" + cacheName;
            Object container = (EmbeddedCacheManager)this.containers.get(clusterName);
            if (container == null) {
                GlobalConfiguration global = new GlobalConfiguration();
                global.setAllowDuplicateDomains(globalConfig.isAllowDuplicateDomains());
                global.setAsyncListenerExecutorFactoryClass(globalConfig.getAsyncListenerExecutorFactoryClass());
                global.setAsyncListenerExecutorProperties(globalConfig.getAsyncListenerExecutorProperties());
                global.setAsyncTransportExecutorFactoryClass(globalConfig.getAsyncTransportExecutorFactoryClass());
                global.setAsyncTransportExecutorProperties(globalConfig.getAsyncTransportExecutorProperties());
                global.setCacheManagerName(globalConfig.getCacheManagerName() + "/" + cacheName);
                global.setClusterName(clusterName);
                global.setDistributedSyncTimeout(globalConfig.getDistributedSyncTimeout());
                global.setEvictionScheduledExecutorFactoryClass(globalConfig.getEvictionScheduledExecutorFactoryClass());
                global.setEvictionScheduledExecutorProperties(globalConfig.getEvictionScheduledExecutorProperties());
                global.setExposeGlobalJmxStatistics(globalConfig.isExposeGlobalJmxStatistics());
                global.setJmxDomain(globalConfig.getJmxDomain());
                global.setMachineId(globalConfig.getMachineId());
                global.setMarshallerClass(globalConfig.getMarshallerClass());
                global.setMarshallVersion(globalConfig.getMarshallVersion());
                global.setMBeanServerLookup(globalConfig.getMBeanServerLookup());
                global.setRackId(globalConfig.getRackId());
                global.setReplicationQueueScheduledExecutorFactoryClass(globalConfig.getReplicationQueueScheduledExecutorFactoryClass());
                global.setReplicationQueueScheduledExecutorProperties(globalConfig.getReplicationQueueScheduledExecutorProperties());
                global.setShutdownHookBehavior(globalConfig.getShutdownHookBehavior());
                global.setSiteId(globalConfig.getSiteId());
                global.setStrictPeerToPeer(globalConfig.isStrictPeerToPeer());
                global.setTransportClass(globalConfig.getTransportClass());
                global.setTransportNodeName(globalConfig.getTransportNodeName());
                Properties properties = new Properties(globalConfig.getTransportProperties());
                properties.setProperty("channelId", clusterName);
                global.setTransportProperties(properties);
                container = new SingletonCacheManager((CacheContainer)this, cacheName, global, config);
                EmbeddedCacheManager existing = this.containers.putIfAbsent(clusterName, (EmbeddedCacheManager)container);
                if (existing == null) {
                    container.addListener((Object)this);
                    for (Object listener : this.container.getListeners()) {
                        container.addListener(listener);
                    }
                    container.start();
                } else {
                    container = existing;
                }
            }
            return container.getCache(cacheName);
        }
        return this.container.getCache(cacheName);
    }

    public synchronized void start() {
        this.container.start();
    }

    public synchronized void stop() {
        this.container.stop();
    }

    public void addListener(Object listener) {
        this.container.addListener(listener);
    }

    public void removeListener(Object listener) {
        this.container.removeListener(listener);
    }

    public Set<Object> getListeners() {
        return this.container.getListeners();
    }

    public Configuration defineConfiguration(String cacheName, Configuration configurationOverride) {
        return this.container.defineConfiguration(cacheName, configurationOverride);
    }

    public Configuration defineConfiguration(String cacheName, String templateCacheName, Configuration configurationOverride) {
        return this.container.defineConfiguration(cacheName, templateCacheName, configurationOverride);
    }

    public String getClusterName() {
        return this.container.getClusterName();
    }

    public List<Address> getMembers() {
        return this.container.getMembers();
    }

    public Address getAddress() {
        return this.container.getAddress();
    }

    public boolean isCoordinator() {
        return this.container.isCoordinator();
    }

    public ComponentStatus getStatus() {
        return this.container.getStatus();
    }

    public GlobalConfiguration getGlobalConfiguration() {
        return this.container.getGlobalConfiguration();
    }

    public Configuration getDefaultConfiguration() {
        return this.container.getDefaultConfiguration();
    }

    public Set<String> getCacheNames() {
        return this.container.getCacheNames();
    }

    @CacheStopped
    public synchronized void cacheStopped(CacheStoppedEvent event) {
        EmbeddedCacheManager manager = event.getCacheManager();
        this.containers.remove(manager.getClusterName());
        manager.stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SingletonCacheManager
    extends DefaultCacheManager {
        private final CacheContainer parent;
        private final String cacheName;

        SingletonCacheManager(CacheContainer parent, String cacheName, GlobalConfiguration globalConfiguration, Configuration defaultConfiguration) {
            super(globalConfiguration, defaultConfiguration, false);
            this.parent = parent;
            this.cacheName = cacheName;
        }

        public <K, V> Cache<K, V> getCache(String name) {
            if (this.cacheName.equals(name)) {
                return super.getCache("___defaultcache");
            }
            return this.parent.getCache(name);
        }

        public void addListener(Object listener) {
            super.addListener(listener);
            if (listener != this.parent) {
                super.removeListener((Object)this.parent);
                super.addListener((Object)this.parent);
            }
        }
    }
}

