/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.ispn;

import java.util.Properties;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelLookup;
import org.jboss.ha.ispn.CacheContainerConfiguration;
import org.jboss.ha.ispn.CacheContainerFactory;
import org.jboss.ha.ispn.DefaultCacheContainer;
import org.jgroups.Channel;
import org.jgroups.ChannelFactory;

public class DefaultCacheContainerFactory
implements CacheContainerFactory {
    public static final String CHANNEL_ID = "channelId";
    public static final String CHANNEL_FACTORY = "channelFactory";
    private final ChannelFactory channelFactory;

    public DefaultCacheContainerFactory(ChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public EmbeddedCacheManager createCacheContainer(CacheContainerConfiguration configuration) {
        GlobalConfiguration globalConfiguration = configuration.getGlobalConfiguration();
        if (globalConfiguration.getTransportClass() != null) {
            globalConfiguration.setStrictPeerToPeer(false);
            Properties properties = globalConfiguration.getTransportProperties();
            if (!properties.containsKey("channelLookup")) {
                properties.put(CHANNEL_FACTORY, this.channelFactory);
                properties.setProperty(CHANNEL_ID, globalConfiguration.getClusterName());
                properties.setProperty("channelLookup", ChannelFactoryChannelLookup.class.getName());
            }
        }
        DefaultCacheManager manager = new DefaultCacheManager(globalConfiguration, configuration.getDefaultConfiguration(), false);
        for (Configuration config : configuration.getNamedConfigurations()) {
            manager.defineConfiguration(config.getName(), config);
        }
        return new DefaultCacheContainer((EmbeddedCacheManager)manager);
    }

    public static class ChannelFactoryChannelLookup
    implements JGroupsChannelLookup {
        public static final String STACK = "stack";
        public static final String DEFAULT_STACK = "udp";
        public static final String AUTO_START = "auto-start";
        public static final String DEFAULT_AUTO_START = Boolean.toString(true);
        public static final String AUTO_STOP = "auto-stop";
        public static final String DEFAULT_AUTO_STOP = Boolean.toString(true);
        private boolean autoStart = true;
        private boolean autoStop = true;

        public Channel getJGroupsChannel(Properties properties) {
            this.autoStart = Boolean.valueOf(properties.getProperty(AUTO_START, DEFAULT_AUTO_START));
            this.autoStop = Boolean.valueOf(properties.getProperty(AUTO_STOP, DEFAULT_AUTO_STOP));
            String stack = properties.getProperty(STACK, DEFAULT_STACK);
            String id = properties.getProperty(DefaultCacheContainerFactory.CHANNEL_ID);
            ChannelFactory factory = (ChannelFactory)properties.get(DefaultCacheContainerFactory.CHANNEL_FACTORY);
            try {
                return factory.createMultiplexerChannel(stack, id);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        public boolean shouldStartAndConnect() {
            return this.autoStart;
        }

        public boolean shouldStopAndDisconnect() {
            return this.autoStop;
        }
    }
}

