/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.ispn;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.jboss.ha.ispn.CacheContainerConfiguration;
import org.jboss.ha.ispn.CacheContainerFactory;
import org.jboss.ha.ispn.CacheContainerRegistry;
import org.jboss.ha.ispn.config.CacheContainerRegistryConfiguration;
import org.jboss.ha.ispn.config.CacheContainerRegistryConfigurationEntry;
import org.jboss.ha.ispn.config.CacheContainerRegistryConfigurationSource;
import org.jboss.logging.Logger;
import org.jboss.util.naming.NonSerializableFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheContainerRegistry
implements CacheContainerRegistry {
    public static final String DEFAULT_CACHE_MANAGER_NAME = new GlobalConfiguration().getCacheManagerName();
    static Logger logger = Logger.getLogger(DefaultCacheContainerRegistry.class);
    private static final AtomicReference<CacheContainerRegistry> singleton = new AtomicReference();
    private final CacheContainerFactory factory;
    private final CacheContainerRegistryConfigurationSource source;
    private final ConcurrentMap<String, String> aliases = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, CacheContainerRegistryEntry> containers = new ConcurrentHashMap<String, CacheContainerRegistryEntry>();
    private volatile String jndiNamePrefix = null;
    private volatile EmbeddedCacheManager defaultContainer;

    public static CacheContainerRegistry getInstance() {
        return singleton.get();
    }

    public DefaultCacheContainerRegistry(CacheContainerFactory factory, CacheContainerRegistryConfigurationSource source) {
        this.factory = factory;
        this.source = source;
    }

    public String getJndiNamePrefix() {
        return this.jndiNamePrefix;
    }

    public void setJndiNamePrefix(String jndiNamePrefix) {
        this.jndiNamePrefix = jndiNamePrefix;
    }

    public void start() throws Exception {
        CacheContainerRegistryConfiguration registry = this.source.getRegistryConfiguration();
        for (CacheContainerRegistryConfigurationEntry entry : registry.getEntries()) {
            this.add(entry);
        }
        CacheContainerRegistryConfigurationEntry defaultEntry = registry.getDefaultEntry();
        if (defaultEntry == null) {
            defaultEntry = registry.getEntries().get(0);
        }
        this.defaultContainer = ((CacheContainerRegistryEntry)this.containers.get(defaultEntry.getId())).getContainer();
        singleton.compareAndSet(null, this);
    }

    public void stop() throws Exception {
        singleton.set(null);
        for (CacheContainerRegistryEntry entry : this.containers.values()) {
            this.stop(entry);
        }
        this.aliases.clear();
        this.containers.clear();
        this.defaultContainer = null;
    }

    @Override
    public Set<String> getCacheContainers() {
        return Collections.unmodifiableSet(this.containers.keySet());
    }

    @Override
    public EmbeddedCacheManager getCacheContainer() {
        return this.defaultContainer;
    }

    @Override
    public EmbeddedCacheManager getCacheContainer(String alias) {
        CacheContainerRegistryEntry entry = null;
        if (alias != null) {
            String id = (String)this.aliases.get(alias);
            entry = (CacheContainerRegistryEntry)this.containers.get(id != null ? id : alias);
        }
        return entry != null ? entry.getContainer() : this.defaultContainer;
    }

    public void add(CacheContainerRegistryConfigurationEntry configEntry) throws NamingException {
        CacheContainerRegistryEntry entry;
        CacheContainerRegistryEntry existingEntry;
        String id = configEntry.getId();
        CacheContainerConfiguration config = configEntry.getConfiguration();
        GlobalConfiguration globalConfig = config.getGlobalConfiguration();
        if (globalConfig.getCacheManagerName() == DEFAULT_CACHE_MANAGER_NAME) {
            globalConfig.setCacheManagerName(id);
        }
        EmbeddedCacheManager container = this.factory.createCacheContainer(config);
        String jndiName = configEntry.getJndiName();
        List<String> aliases = configEntry.getAliases();
        String prefix = this.jndiNamePrefix;
        if (prefix != null && jndiName == null) {
            jndiName = prefix + "/" + id;
        }
        if ((existingEntry = this.containers.putIfAbsent(id, entry = new CacheContainerRegistryEntry(id, container, jndiName, aliases))) != null) {
            throw new IllegalArgumentException(id + " cache container is already registered.");
        }
        for (String alias : aliases) {
            String existingAlias = this.aliases.putIfAbsent(alias, id);
            if (existingAlias == null) continue;
            logger.warn((Object)("Ignoring alias " + alias + " for " + id + " cache container because it is already assigned to " + existingAlias));
        }
        this.start(entry);
    }

    public void remove(CacheContainerRegistryConfigurationEntry configEntry) {
        CacheContainerRegistryEntry entry = (CacheContainerRegistryEntry)this.containers.remove(configEntry.getId());
        if (entry != null) {
            for (String alias : entry.getAliases()) {
                this.aliases.remove(alias);
            }
            this.stop(entry);
        }
    }

    private void start(CacheContainerRegistryEntry entry) {
        EmbeddedCacheManager container = entry.getContainer();
        container.start();
        container.addListener((Object)entry);
        String jndiName = entry.getJndiName();
        if (jndiName != null) {
            try {
                logger.info((Object)("Binding " + entry.getId() + " cache container to " + jndiName));
                this.bind(jndiName, container);
            }
            catch (NamingException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void stop(CacheContainerRegistryEntry entry) {
        String jndiName = entry.getJndiName();
        if (jndiName != null) {
            try {
                logger.info((Object)("Unbinding " + entry.getId() + " cache container from " + jndiName));
                this.unbind(jndiName);
            }
            catch (NamingException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        EmbeddedCacheManager container = entry.getContainer();
        container.removeListener((Object)entry);
        container.stop();
    }

    private void bind(String jndiName, Object value) throws NamingException {
        InitialContext context = new InitialContext();
        Name name = context.getNameParser("").parse(jndiName);
        int end = name.size();
        for (int i = 1; i < end; ++i) {
            Name subcontextName = name.getPrefix(i);
            try {
                context.lookup(subcontextName);
                continue;
            }
            catch (NameNotFoundException e) {
                logger.trace((Object)("Creating subcontext " + subcontextName));
                context.createSubcontext(subcontextName);
            }
        }
        NonSerializableFactory.rebind((Context)context, (String)jndiName, (Object)value);
    }

    private void unbind(String name) throws NamingException {
        new InitialContext().unbind(name);
        NonSerializableFactory.unbind((String)name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Listener
    public static class CacheContainerRegistryEntry {
        private final String id;
        private final List<String> aliases;
        private final String jndiName;
        private final EmbeddedCacheManager container;

        public CacheContainerRegistryEntry(String id, EmbeddedCacheManager container, String jndiName, List<String> aliases) {
            this.id = id;
            this.container = container;
            this.jndiName = jndiName;
            this.aliases = aliases;
        }

        public String getId() {
            return this.id;
        }

        public EmbeddedCacheManager getContainer() {
            return this.container;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        @CacheStarted
        public void cacheStarted(CacheStartedEvent event) {
            this.log("Started", event.getCacheName());
        }

        @CacheStopped
        public void cacheStopped(CacheStoppedEvent event) {
            this.log("Stopped", event.getCacheName());
        }

        private void log(String event, String cacheName) {
            logger.info((Object)String.format("%s \"%s\" cache from \"%s\" container", event, cacheName, this.id));
        }
    }
}

