/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ha.ispn;

import java.util.Set;

import org.infinispan.manager.EmbeddedCacheManager;

/**
 * A registry of Infinispan cache containers.
 * @author Paul Ferraro
 */
public interface CacheContainerRegistry
{
   /**
    * Returns the default cache container.
    * Equivalent to getCacheContainer(null).
    * @return an Infinispan cache container.
    */
   EmbeddedCacheManager getCacheContainer();
   
   /**
    * Returns the cache container associated with the specified identifier,
    * or the default cache container if there is no associated cache container
    * or the specified id is null.
    * @param id a cache container identifier
    * @return an Infinispan cache container.
    */
   EmbeddedCacheManager getCacheContainer(String id);
   
   /**
    * Returns the identifiers of all cache containers in this registry.
    * @return a set of cache container identifiers.
    */
   Set<String> getCacheContainers();
}
