/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ha.ispn.config;

import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * Root element for cache container registry configuration.
 * @author Paul Ferraro
 */
@XmlRootElement(name = "infinispan-configs")
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType
public class CacheContainerRegistryConfiguration
{
   @XmlIDREF
   @XmlAttribute(name = "default", required = false)
   private CacheContainerRegistryConfigurationEntry defaultEntry;

   @XmlElement(name = "infinispan-config")
   private List<CacheContainerRegistryConfigurationEntry> entries;
   
   public CacheContainerRegistryConfigurationEntry getDefaultEntry()
   {
      return this.defaultEntry;
   }
   
   public void setDefaultEntry(CacheContainerRegistryConfigurationEntry defaultEntry)
   {
      this.defaultEntry = defaultEntry;
   }
   
   public List<CacheContainerRegistryConfigurationEntry> getEntries()
   {
      return this.entries;
   }

   public void setEntries(List<CacheContainerRegistryConfigurationEntry> entries)
   {
      this.entries = entries;
   }
}
