/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ha.ispn.config;

import java.util.LinkedList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.infinispan.config.InfinispanConfiguration;
import org.jboss.ha.ispn.CacheContainerConfiguration;

/**
 * A cache container registry configuration entry.
 * @author Paul Ferraro
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType
public class CacheContainerRegistryConfigurationEntry
{
   @XmlID
   @XmlAttribute(name = "name", required = true)
   private String id;
   @XmlAttribute(name = "jndi-name", required = false)
   private String jndiName;
   
   @XmlElement(name = "alias")
   private List<String> aliases = new LinkedList<String>();
   
   @XmlJavaTypeAdapter(InfinispanConfigurationAdapter.class)
   @XmlElementRef(type = InfinispanConfiguration.class)
   private CacheContainerConfiguration configuration;

   public String getId()
   {
      return this.id;
   }
   
   public void setId(String id)
   {
      this.id = id;
   }
   
   public String getJndiName()
   {
      return this.jndiName;
   }

   public void setJndiName(String jndiName)
   {
      this.jndiName = jndiName;
   }
   
   public List<String> getAliases()
   {
      return this.aliases;
   }
   
   public void setAliases(List<String> aliases)
   {
      this.aliases = aliases;
   }
   
   public CacheContainerConfiguration getConfiguration()
   {
      return this.configuration;
   }
   
   public void setConfiguration(CacheContainerConfiguration configuration)
   {
      this.configuration = configuration;
   }
}
