/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ha.ispn.config;

import java.io.IOException;
import java.util.Collections;

import org.infinispan.config.InfinispanConfiguration;

/**
 * A source for a cache container registry that parses an single Infinispan configuration file.
 * @author Paul Ferraro
 */
public class SingleCacheContainerRegistryConfigurationSource implements CacheContainerRegistryConfigurationSource
{
   public static final String DEFAULT_ID = "default";
   
   private final String resource;
   
   private String id = DEFAULT_ID;
   private String jndiName;
   
   /**
    * Creates a new SingleCacheContainerRegistryConfigurationSource
    * @param id the identifier of the singleton cache container
    * @param jndiName the jndi name for the cache container
    * @param resource the classpath resource containing the infinispan cache container configuration.
    */
   public SingleCacheContainerRegistryConfigurationSource(String resource)
   {
      this.resource = resource;
   }

   public void setId(String id)
   {
      this.id = id;
   }
   
   public void setJndiName(String jndiName)
   {
      this.jndiName = jndiName;
   }
   
   /**
    * {@inheritDoc}
    * @see org.jboss.ha.ispn.config.CacheContainerRegistryConfigurationSource#getRegistryConfiguration()
    */
   @Override
   public CacheContainerRegistryConfiguration getRegistryConfiguration() throws IOException
   {
      InfinispanConfiguration configuration = InfinispanConfiguration.newInfinispanConfiguration(this.resource);
      
      CacheContainerRegistryConfigurationEntry entry = new CacheContainerRegistryConfigurationEntry();
      entry.setId(this.id);
      entry.setJndiName(this.jndiName);
      entry.setConfiguration(new InfinispanConfigurationAdapter().unmarshal(configuration));
      
      CacheContainerRegistryConfiguration registry = new CacheContainerRegistryConfiguration();
      registry.setDefaultEntry(entry);
      registry.setEntries(Collections.singletonList(entry));
      
      return registry;
   }
}
