/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.common.beans.property;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.common.beans.property.BooleanArrayEditor;
import org.jboss.common.beans.property.BooleanEditor;
import org.jboss.common.beans.property.ByteArrayEditor;
import org.jboss.common.beans.property.ByteEditor;
import org.jboss.common.beans.property.CharacterArrayEditor;
import org.jboss.common.beans.property.CharacterEditor;
import org.jboss.common.beans.property.ClassArrayEditor;
import org.jboss.common.beans.property.DoubleArrayEditor;
import org.jboss.common.beans.property.DoubleEditor;
import org.jboss.common.beans.property.FloatArrayEditor;
import org.jboss.common.beans.property.FloatEditor;
import org.jboss.common.beans.property.GenericArrayPropertyEditor;
import org.jboss.common.beans.property.InetAddressArrayEditor;
import org.jboss.common.beans.property.IntArrayEditor;
import org.jboss.common.beans.property.IntegerEditor;
import org.jboss.common.beans.property.LongArrayEditor;
import org.jboss.common.beans.property.LongEditor;
import org.jboss.common.beans.property.ShortArrayEditor;
import org.jboss.common.beans.property.ShortEditor;
import org.jboss.common.beans.property.StringArrayEditor;

public class PropertyEditors {
    private static Logger log = Logger.getLogger(PropertyEditors.class.getName());
    private static final String NULL = "null";
    private static boolean disableIsNull = false;
    private static boolean initialized = false;
    private static final Map PRIMITIVE_NAME_TYPE_MAP;

    public static synchronized void init() {
        if (!initialized) {
            AccessController.doPrivileged(Initialize.instance);
            initialized = true;
        }
    }

    public static final boolean isNull(String value) {
        return PropertyEditors.isNull(value, true, true);
    }

    public static final boolean isNull(String value, boolean trim, boolean empty) {
        String trimmed;
        if (disableIsNull) {
            return false;
        }
        if (value == null) {
            return true;
        }
        String string = trimmed = trim ? value.trim() : value;
        if (empty && trimmed.length() == 0) {
            return true;
        }
        return NULL.equalsIgnoreCase(trimmed);
    }

    public static boolean isNullHandlingEnabled() {
        return !disableIsNull;
    }

    public static PropertyEditor findEditor(Class<?> type) {
        Class<?> cellType;
        GenericArrayPropertyEditor pe = PropertyEditorManager.findEditor(type);
        if (pe == null && type.isArray() && PropertyEditorManager.findEditor(cellType = type.getComponentType()) != null) {
            pe = new GenericArrayPropertyEditor(type);
        }
        return pe;
    }

    public static PropertyEditor findEditor(String typeName) throws ClassNotFoundException {
        Class<?> type = PropertyEditors.getPrimitiveTypeForName(typeName);
        if (type == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            type = loader.loadClass(typeName);
        }
        return PropertyEditors.findEditor(type);
    }

    public static PropertyEditor getEditor(Class<?> type) {
        PropertyEditor editor = PropertyEditors.findEditor(type);
        if (editor == null) {
            throw new IllegalArgumentException("No property editor for type: " + type);
        }
        return editor;
    }

    public static PropertyEditor getEditor(String typeName) throws ClassNotFoundException {
        PropertyEditor editor = PropertyEditors.findEditor(typeName);
        if (editor == null) {
            throw new RuntimeException("No property editor for type: " + typeName);
        }
        return editor;
    }

    public static void registerEditor(Class<?> type, Class<?> editorType) {
        PropertyEditorManager.registerEditor(type, editorType);
    }

    public static void registerEditor(String typeName, String editorTypeName) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> type = loader.loadClass(typeName);
        Class<?> editorType = loader.loadClass(editorTypeName);
        PropertyEditorManager.registerEditor(type, editorType);
    }

    public static Object convertValue(String text, String typeName) throws ClassNotFoundException, IntrospectionException {
        PropertyEditor editor;
        Class<?> typeClass = PropertyEditors.getPrimitiveTypeForName(typeName);
        if (typeClass == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            typeClass = loader.loadClass(typeName);
        }
        if ((editor = PropertyEditorManager.findEditor(typeClass)) == null) {
            throw new IntrospectionException("No property editor for type=" + typeClass);
        }
        editor.setAsText(text);
        return editor.getValue();
    }

    public static void mapJavaBeanProperties(Object bean, Properties beanProps) throws IntrospectionException {
        PropertyEditors.mapJavaBeanProperties(bean, beanProps, true);
    }

    public static void mapJavaBeanProperties(Object bean, Properties beanProps, boolean isStrict) throws IntrospectionException {
        HashMap<String, PropertyDescriptor> propertyMap = new HashMap<String, PropertyDescriptor>();
        BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
        PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
        for (int p = 0; p < props.length; ++p) {
            String fieldName = props[p].getName();
            propertyMap.put(fieldName, props[p]);
        }
        boolean finestLog = log.isLoggable(Level.FINEST);
        Iterator<Object> keys = beanProps.keySet().iterator();
        if (finestLog) {
            log.finest("Mapping properties for bean: " + bean);
        }
        while (keys.hasNext()) {
            String name = (String)keys.next();
            String text = beanProps.getProperty(name);
            PropertyDescriptor pd = (PropertyDescriptor)propertyMap.get(name);
            if (pd == null) {
                char first;
                String exName;
                if (name.length() > 1 && (pd = (PropertyDescriptor)propertyMap.get(exName = Character.toUpperCase(first = name.charAt(0)) + name.substring(1))) == null) {
                    exName = Character.toLowerCase(first) + name.substring(1);
                    pd = (PropertyDescriptor)propertyMap.get(exName);
                }
                if (pd == null) {
                    if (!isStrict) continue;
                    String msg = "No property found for: " + name + " on JavaBean: " + bean;
                    throw new IntrospectionException(msg);
                }
            }
            Method setter = pd.getWriteMethod();
            if (finestLog) {
                log.finest("Property editor found for: " + name + ", editor: " + pd + ", setter: " + setter);
            }
            if (setter == null) continue;
            Class<?> ptype = pd.getPropertyType();
            PropertyEditor editor = PropertyEditorManager.findEditor(ptype);
            if (editor == null && finestLog) {
                log.finest("Failed to find property editor for: " + name);
            }
            try {
                editor.setAsText(text);
                Object[] args = new Object[]{editor.getValue()};
                setter.invoke(bean, args);
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.SEVERE)) continue;
                log.log(Level.SEVERE, "Failed to write property", e);
            }
        }
    }

    public String[] getEditorSearchPath() {
        return PropertyEditorManager.getEditorSearchPath();
    }

    public void setEditorSearchPath(String[] path) {
        PropertyEditorManager.setEditorSearchPath(path);
    }

    public static Class getPrimitiveTypeForName(String name) {
        return (Class)PRIMITIVE_NAME_TYPE_MAP.get(name);
    }

    static {
        PropertyEditors.init();
        PRIMITIVE_NAME_TYPE_MAP = new HashMap();
        PRIMITIVE_NAME_TYPE_MAP.put("boolean", Boolean.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("byte", Byte.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("char", Character.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("short", Short.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("int", Integer.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("long", Long.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("float", Float.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("double", Double.TYPE);
    }

    private static class Initialize
    implements PrivilegedAction<Object> {
        static Initialize instance = new Initialize();

        private Initialize() {
        }

        @Override
        public Object run() {
            block3: {
                String[] currentPath = PropertyEditorManager.getEditorSearchPath();
                int length = currentPath != null ? currentPath.length : 0;
                String[] newPath = new String[length + 1];
                System.arraycopy(currentPath, 0, newPath, 1, length);
                newPath[0] = "org.jboss.common.beans.property";
                PropertyEditorManager.registerEditor(Byte.TYPE, ByteEditor.class);
                PropertyEditorManager.registerEditor(Short.TYPE, ShortEditor.class);
                PropertyEditorManager.registerEditor(Integer.TYPE, IntegerEditor.class);
                PropertyEditorManager.registerEditor(Long.TYPE, LongEditor.class);
                PropertyEditorManager.registerEditor(Boolean.TYPE, BooleanEditor.class);
                PropertyEditorManager.registerEditor(Float.TYPE, FloatEditor.class);
                PropertyEditorManager.registerEditor(Double.TYPE, DoubleEditor.class);
                PropertyEditorManager.registerEditor(Character.TYPE, CharacterEditor.class);
                Class<String[]> strArrayType = String[].class;
                PropertyEditorManager.registerEditor(strArrayType, StringArrayEditor.class);
                Class<Class[]> clsArrayType = Class[].class;
                PropertyEditorManager.registerEditor(clsArrayType, ClassArrayEditor.class);
                Class<int[]> intArrayType = int[].class;
                PropertyEditorManager.registerEditor(intArrayType, IntArrayEditor.class);
                Class<byte[]> byteArrayType = byte[].class;
                PropertyEditorManager.registerEditor(byteArrayType, ByteArrayEditor.class);
                Class<boolean[]> booleanArrayType = boolean[].class;
                PropertyEditorManager.registerEditor(booleanArrayType, BooleanArrayEditor.class);
                Class<char[]> charArrayType = char[].class;
                PropertyEditorManager.registerEditor(charArrayType, CharacterArrayEditor.class);
                Class<double[]> doubleArrayType = double[].class;
                PropertyEditorManager.registerEditor(doubleArrayType, DoubleArrayEditor.class);
                Class<float[]> floatArrayType = float[].class;
                PropertyEditorManager.registerEditor(floatArrayType, FloatArrayEditor.class);
                Class<long[]> longArrayType = long[].class;
                PropertyEditorManager.registerEditor(longArrayType, LongArrayEditor.class);
                Class<short[]> shortArrayType = short[].class;
                PropertyEditorManager.registerEditor(shortArrayType, ShortArrayEditor.class);
                Class<InetAddress[]> inetAddressArrayType = InetAddress[].class;
                PropertyEditorManager.registerEditor(inetAddressArrayType, InetAddressArrayEditor.class);
                PropertyEditorManager.setEditorSearchPath(newPath);
                try {
                    if (System.getProperty("org.jboss.util.property.disablenull") != null) {
                        disableIsNull = true;
                    }
                }
                catch (Throwable ignored) {
                    if (!log.isLoggable(Level.SEVERE)) break block3;
                    log.log(Level.SEVERE, "Error retrieving system property org.jboss.util.property.diablenull", ignored);
                }
            }
            return null;
        }
    }
}

