/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.common.beans.property;

public final class BeanUtils {
    private static final String NULL = "null";

    public static Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            if (loader != null) {
                return Class.forName(name, false, loader);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Class.forName(name);
    }

    public static Class<?> findClass(String name, ClassLoader loader) throws ClassNotFoundException {
        if (loader != null) {
            try {
                return Class.forName(name, false, loader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return BeanUtils.findClass(name);
    }

    public static boolean isNull(String value) {
        return BeanUtils.isNull(value, true, true);
    }

    public static boolean isNull(String value, boolean trim, boolean empty) {
        String trimmed;
        if (value == null) {
            return true;
        }
        String string = trimmed = trim ? value.trim() : value;
        if (empty && trimmed.length() == 0) {
            return true;
        }
        return NULL.equalsIgnoreCase(trimmed);
    }
}

