/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.common.beans.property;

import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.util.StringTokenizer;
import org.jboss.common.beans.property.BeanUtils;
import org.jboss.common.beans.property.PropertyEditorSupport;
import org.jboss.common.beans.property.finder.PropertyEditorFinder;

public class GenericArrayPropertyEditor<T>
extends PropertyEditorSupport<T> {
    private final Class<?> cellType;

    public GenericArrayPropertyEditor(Class<T> initType) {
        super(initType);
        if (!initType.isArray()) {
            throw new IllegalArgumentException("Type is not array! " + initType);
        }
        this.cellType = initType.getComponentType();
        PropertyEditor cellPropertyEditor = PropertyEditorFinder.getInstance().find(this.cellType);
        if (cellPropertyEditor == null) {
            throw new IllegalArgumentException("No editor found for '" + this.cellType + "'");
        }
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (BeanUtils.isNull(text)) {
            this.setValue(null);
            return;
        }
        PropertyEditor cellPropertyEditor = PropertyEditorFinder.getInstance().find(this.cellType);
        String[] cellStringValues = this.tokenize(text);
        Object reflectiveArray = Array.newInstance(this.cellType, cellStringValues.length);
        for (int index = 0; index < cellStringValues.length; ++index) {
            cellPropertyEditor.setAsText(cellStringValues[index]);
            Object cellValue = cellPropertyEditor.getValue();
            Array.set(reflectiveArray, index, cellValue);
        }
        this.setValue(reflectiveArray);
    }

    @Override
    public String getAsText() {
        Object reflectiveArray = this.getValue();
        if (reflectiveArray == null) {
            return null;
        }
        PropertyEditor cellPropertyEditor = PropertyEditorFinder.getInstance().find(this.cellType);
        int length = Array.getLength(reflectiveArray);
        String[] cellStringValues = new String[length];
        for (int index = 0; index < length; ++index) {
            Object cellValue = Array.get(reflectiveArray, index);
            cellPropertyEditor.setValue(cellValue);
            cellStringValues[index] = cellPropertyEditor.getAsText();
        }
        return this.encode(cellStringValues);
    }

    protected String[] tokenize(String text) {
        StringTokenizer tokenizer = new StringTokenizer(text, "\r\n,");
        String[] tokens = new String[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreElements()) {
            tokens[index++] = tokenizer.nextToken();
        }
        return tokens;
    }

    protected String encode(String[] v) {
        StringBuffer text = new StringBuffer();
        for (int index = 0; index < v.length; ++index) {
            if (index > 0) {
                text.append(',');
            }
            text.append(v[index]);
        }
        return text.toString();
    }

    protected Class<?> getCellType() {
        return this.cellType;
    }
}

