/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.common.beans.property.finder;

import java.beans.PropertyEditor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;

public abstract class PropertyEditorFinder {
    protected static Logger logger = Logger.getLogger(PropertyEditorFinder.class.getName());
    protected static final String _EDITOR = "Editor";
    protected static final String _EDITOR_ARRAY = "ArrayEditor";
    private static final Map<String, Class<?>> PRIMITIVE_NAME_TYPE_MAP;
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS;
    private static final Object _LOCK;
    private static volatile PropertyEditorFinder _INSTANCE;

    protected static String stripPackage(String fqn) {
        return fqn.substring(fqn.lastIndexOf(46) + 1, fqn.length());
    }

    protected static String stripPackage(Class<?> clazz) {
        String fqn = clazz.getName();
        return fqn.substring(fqn.lastIndexOf(46) + 1, fqn.length());
    }

    protected static Class<?> getPrimitiveTypeForName(String name) {
        return PRIMITIVE_NAME_TYPE_MAP.get(name);
    }

    protected static Class<?> getWrapperTypeFor(Class<?> primitive) {
        return PRIMITIVES_TO_WRAPPERS.get(primitive);
    }

    public abstract PropertyEditor find(Class<?> var1);

    public abstract void register(Class<?> var1, Class<? extends PropertyEditor> var2);

    public abstract void setEditorSearchPackages(String[] var1);

    public abstract String[] getEditorSearchPackages();

    private static void init() {
        ServiceLoader<PropertyEditorFinder> service = ServiceLoader.load(PropertyEditorFinder.class);
        Iterator<PropertyEditorFinder> it = service.iterator();
        if (it.hasNext()) {
            _INSTANCE = it.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyEditorFinder getInstance() {
        PropertyEditorFinder result = _INSTANCE;
        if (result == null) {
            Object object = _LOCK;
            synchronized (object) {
                result = _INSTANCE;
                if (result == null) {
                    PropertyEditorFinder.init();
                    result = _INSTANCE;
                }
            }
        }
        return result;
    }

    static {
        HashMap<String, Class<Comparable<Boolean>>> tmp = new HashMap<String, Class<Comparable<Boolean>>>();
        tmp.put("boolean", Boolean.TYPE);
        tmp.put("byte", Byte.TYPE);
        tmp.put("char", Character.TYPE);
        tmp.put("short", Short.TYPE);
        tmp.put("int", Integer.TYPE);
        tmp.put("long", Long.TYPE);
        tmp.put("float", Float.TYPE);
        tmp.put("double", Double.TYPE);
        PRIMITIVE_NAME_TYPE_MAP = Collections.unmodifiableMap(tmp);
        HashMap<Class<Object>, Class<Void>> tmp2 = new HashMap<Class<Object>, Class<Void>>();
        tmp2.put(Boolean.TYPE, Boolean.class);
        tmp2.put(Byte.TYPE, Byte.class);
        tmp2.put(Character.TYPE, Character.class);
        tmp2.put(Double.TYPE, Double.class);
        tmp2.put(Float.TYPE, Float.class);
        tmp2.put(Integer.TYPE, Integer.class);
        tmp2.put(Long.TYPE, Long.class);
        tmp2.put(Short.TYPE, Short.class);
        tmp2.put(Void.TYPE, Void.class);
        PRIMITIVES_TO_WRAPPERS = Collections.unmodifiableMap(tmp2);
        _LOCK = new Object();
    }
}

