/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.common.beans.property.finder;

import java.beans.PropertyEditor;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.common.beans.property.BeanUtils;
import org.jboss.common.beans.property.BooleanArrayEditor;
import org.jboss.common.beans.property.BooleanEditor;
import org.jboss.common.beans.property.ByteArrayEditor;
import org.jboss.common.beans.property.ByteEditor;
import org.jboss.common.beans.property.CharacterArrayEditor;
import org.jboss.common.beans.property.CharacterEditor;
import org.jboss.common.beans.property.ClassArrayEditor;
import org.jboss.common.beans.property.DoubleArrayEditor;
import org.jboss.common.beans.property.DoubleEditor;
import org.jboss.common.beans.property.FloatArrayEditor;
import org.jboss.common.beans.property.FloatEditor;
import org.jboss.common.beans.property.GenericArrayPropertyEditor;
import org.jboss.common.beans.property.InetAddressArrayEditor;
import org.jboss.common.beans.property.IntegerArrayEditor;
import org.jboss.common.beans.property.IntegerEditor;
import org.jboss.common.beans.property.LongArrayEditor;
import org.jboss.common.beans.property.LongEditor;
import org.jboss.common.beans.property.ShortArrayEditor;
import org.jboss.common.beans.property.ShortEditor;
import org.jboss.common.beans.property.StringArrayEditor;
import org.jboss.common.beans.property.finder.PropertyEditorFinder;

public class DefaultPropertyEditorFinder
extends PropertyEditorFinder {
    private static final Logger logger = Logger.getLogger(DefaultPropertyEditorFinder.class.getName());
    protected Map<Class<?>, Class<? extends PropertyEditor>> register = new HashMap();
    private String[] packages = new String[]{"org.jboss.common.beans.property"};

    public DefaultPropertyEditorFinder() {
        this.register(Byte.TYPE, ByteEditor.class);
        this.register(Short.TYPE, ShortEditor.class);
        this.register(Integer.TYPE, IntegerEditor.class);
        this.register(Long.TYPE, LongEditor.class);
        this.register(Boolean.TYPE, BooleanEditor.class);
        this.register(Float.TYPE, FloatEditor.class);
        this.register(Double.TYPE, DoubleEditor.class);
        this.register(Character.TYPE, CharacterEditor.class);
        this.register(Byte.class, ByteEditor.class);
        this.register(Short.class, ShortEditor.class);
        this.register(Integer.class, IntegerEditor.class);
        this.register(Long.class, LongEditor.class);
        this.register(Boolean.class, BooleanEditor.class);
        this.register(Float.class, FloatEditor.class);
        this.register(Double.class, DoubleEditor.class);
        this.register(Character.class, CharacterEditor.class);
        Class<String[]> strArrayType = String[].class;
        this.register(strArrayType, StringArrayEditor.class);
        Class<Class[]> clsArrayType = Class[].class;
        this.register(clsArrayType, ClassArrayEditor.class);
        Class<int[]> intArrayType = int[].class;
        this.register(intArrayType, IntegerArrayEditor.class);
        Class<byte[]> byteArrayType = byte[].class;
        this.register(byteArrayType, ByteArrayEditor.class);
        Class<boolean[]> booleanArrayType = boolean[].class;
        this.register(booleanArrayType, BooleanArrayEditor.class);
        Class<char[]> charArrayType = char[].class;
        this.register(charArrayType, CharacterArrayEditor.class);
        Class<double[]> doubleArrayType = double[].class;
        this.register(doubleArrayType, DoubleArrayEditor.class);
        Class<float[]> floatArrayType = float[].class;
        this.register(floatArrayType, FloatArrayEditor.class);
        Class<long[]> longArrayType = long[].class;
        this.register(longArrayType, LongArrayEditor.class);
        Class<short[]> shortArrayType = short[].class;
        this.register(shortArrayType, ShortArrayEditor.class);
        Class<InetAddress[]> inetAddressArrayType = InetAddress[].class;
        this.register(inetAddressArrayType, InetAddressArrayEditor.class);
    }

    @Override
    public void setEditorSearchPackages(String[] packages) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        this.packages = (String[])packages.clone();
    }

    @Override
    public String[] getEditorSearchPackages() {
        return (String[])this.packages.clone();
    }

    @Override
    public void register(Class<?> type, Class<? extends PropertyEditor> editor) {
        if (type == null) {
            throw new IllegalArgumentException("Object type must not be null.");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        this.register.put(type, editor);
    }

    @Override
    public PropertyEditor find(Class<?> type) {
        if (type == null) {
            return null;
        }
        Class<PropertyEditor> editorClass = this.register.get(type);
        if (editorClass != null) {
            try {
                return editorClass.newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        boolean isArray = type.isArray();
        String editorName = BeanUtils.stripPackage(type);
        editorName = isArray ? editorName + "ArrayEditor" : editorName + "Editor";
        String searchName = null;
        try {
            searchName = BeanUtils.stripClass(type) + "." + editorName;
            editorClass = BeanUtils.findClass(searchName);
            return editorClass.newInstance();
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Failed to instantiate property editor class  '" + searchName + "'.", e);
            }
            for (String pkg : this.packages) {
                try {
                    searchName = pkg + "." + editorName;
                    editorClass = BeanUtils.findClass(searchName);
                    return editorClass.newInstance();
                }
                catch (Exception e2) {
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.log(Level.FINEST, "Failed to instantiate property editor class  '" + searchName + "'.", e2);
                }
            }
            if (isArray) {
                Class<?> cellType = type.getComponentType();
                if (this.find(cellType) != null) {
                    return new GenericArrayPropertyEditor(type);
                }
                return null;
            }
            if (type.isPrimitive()) {
                return this.find(BeanUtils.getWrapperTypeFor(type));
            }
            return null;
        }
    }
}

