/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard;

import java.text.MessageFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.dashboard.LocaleManager;
import org.jboss.dashboard.annotation.StartableProcessor;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.factory.Factory;
import org.jboss.dashboard.factory.FactoryWork;

@ApplicationScoped
public class Application {
    @Inject
    protected StartableProcessor startupProcessor;
    protected boolean upAndRunning = false;
    protected String baseCfgDirectory = null;
    protected String baseAppDirectory = null;
    protected Factory globalFactory = null;

    public static Application lookup() {
        return (Application)CDIBeanLocator.getBeanByType(Application.class);
    }

    public String getBaseAppDirectory() {
        return this.baseAppDirectory;
    }

    public String getBaseCfgDirectory() {
        return this.baseCfgDirectory;
    }

    public void setBaseAppDirectory(String newBaseAppDirectory) {
        this.baseAppDirectory = newBaseAppDirectory;
    }

    public void setBaseCfgDirectory(String newBaseCfgDirectory) {
        this.baseCfgDirectory = newBaseCfgDirectory;
    }

    public Factory getGlobalFactory() {
        return this.globalFactory;
    }

    public void setGlobalFactory(Factory globalFactory) {
        if (this.globalFactory != null) {
            Factory.doWork(new FactoryWork(){

                @Override
                public void doWork() {
                    Application.this.globalFactory.destroy();
                }
            });
        }
        this.globalFactory = globalFactory;
    }

    public boolean isUpAndRunning() {
        return this.upAndRunning;
    }

    public void setUpAndRunning(boolean upAndRunning) {
        this.upAndRunning = upAndRunning;
    }

    public void start() throws Exception {
        this.startupProcessor.wakeUpStartableBeans();
        this.setUpAndRunning(true);
    }

    public void shutdown() {
        this.setUpAndRunning(false);
        this.setGlobalFactory(null);
    }

    public String getCopyright() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        String currentYear = Integer.toString(cal.get(1));
        ResourceBundle i18n = ResourceBundle.getBundle("org.jboss.dashboard.messages", LocaleManager.currentLocale());
        return MessageFormat.format(i18n.getString("config.copyright"), currentYear);
    }
}

