/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CDIBeanLocator {
    public static BeanManager beanManager;

    public static BeanManager getBeanManager() {
        if (beanManager != null) {
            return beanManager;
        }
        beanManager = CDIBeanLocator.lookupBeanManager("java:comp/BeanManager");
        if (beanManager == null) {
            beanManager = CDIBeanLocator.lookupBeanManager("java:comp/env/BeanManager");
        }
        return beanManager;
    }

    private static BeanManager lookupBeanManager(String jndiName) {
        try {
            InitialContext initialContext = new InitialContext();
            return (BeanManager)initialContext.lookup(jndiName);
        }
        catch (NamingException e) {
            return null;
        }
    }

    public static Object getBeanByName(String name) {
        BeanManager bm = CDIBeanLocator.getBeanManager();
        Bean bean = (Bean)bm.getBeans(name).iterator().next();
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        Object o = bm.getReference(bean, (Type)bean.getBeanClass(), ctx);
        return o;
    }

    public static Object getBeanByType(Class type) {
        BeanManager bm = CDIBeanLocator.getBeanManager();
        Bean bean = (Bean)bm.getBeans((Type)type, new Annotation[0]).iterator().next();
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        Object o = bm.getReference(bean, (Type)bean.getBeanClass(), ctx);
        return o;
    }
}

