/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.events;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.commons.events.Subscriber;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;

public class Publisher {
    private static transient Log log = LogFactory.getLog(Publisher.class);
    public static final int EVENT_ALL = 0;
    protected Map subscribers = Collections.synchronizedMap(new HashMap());

    public synchronized void subscribe(Subscriber subscriber) {
        if (subscriber == null) {
            return;
        }
        this.subscribe(subscriber, 0);
    }

    public synchronized void subscribe(Subscriber subscriber, int eventId) {
        if (subscriber == null) {
            return;
        }
        this.unsubscribe(subscriber, eventId);
        List<WeakReference<Subscriber>> eventSubscribers = (List<WeakReference<Subscriber>>)this.subscribers.get(new Integer(eventId));
        if (eventSubscribers == null) {
            eventSubscribers = Collections.synchronizedList(new ArrayList());
            this.subscribers.put(new Integer(eventId), eventSubscribers);
        }
        eventSubscribers.add(new WeakReference<Subscriber>(subscriber));
    }

    public synchronized void subscribe(Collection c, int eventId) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.subscribe((Subscriber)it.next(), eventId);
        }
    }

    public synchronized void unsubscribe(Subscriber subscriber) {
        if (subscriber == null) {
            return;
        }
        for (Integer eventId : this.subscribers.keySet()) {
            this.unsubscribe(subscriber, eventId);
        }
    }

    public synchronized void unsubscribe(Subscriber subscriber, int eventId) {
        if (subscriber == null) {
            return;
        }
        List eventSubscribers = (List)this.subscribers.get(new Integer(eventId));
        if (eventSubscribers == null) {
            return;
        }
        Iterator it = eventSubscribers.iterator();
        while (it.hasNext()) {
            WeakReference wr = (WeakReference)it.next();
            Subscriber regSubscr = (Subscriber)wr.get();
            if (regSubscr != null && !regSubscr.equals(subscriber)) continue;
            it.remove();
        }
    }

    public synchronized Map getSubscribers() {
        HashMap<Integer, List> results = new HashMap<Integer, List>();
        for (Integer eventId : this.subscribers.keySet()) {
            results.put(eventId, this.getSubscribers(eventId));
        }
        return results;
    }

    public synchronized List getSubscribers(int eventId) {
        List<Subscriber> results = Collections.synchronizedList(new ArrayList());
        List eventSubscribers = (List)this.subscribers.get(new Integer(eventId));
        if (eventSubscribers == null) {
            return results;
        }
        Iterator it = eventSubscribers.iterator();
        while (it.hasNext()) {
            WeakReference wr = (WeakReference)it.next();
            Subscriber subscriber = (Subscriber)wr.get();
            if (subscriber == null) {
                it.remove();
                continue;
            }
            results.add(subscriber);
        }
        return Collections.unmodifiableList(results);
    }

    public void notifyEvent(final int eventId, final Object eventInfo) {
        HashSet _subscribersToNotify = new HashSet();
        _subscribersToNotify.addAll(this.getSubscribers(eventId));
        _subscribersToNotify.addAll(this.getSubscribers(0));
        Iterator it = _subscribersToNotify.iterator();
        block8: while (it.hasNext()) {
            try {
                final Subscriber subscriber = (Subscriber)it.next();
                switch (subscriber.getTransactionContext()) {
                    case 1: {
                        subscriber.notifyEvent(eventId, eventInfo);
                        continue block8;
                    }
                    case 2: {
                        new HibernateTxFragment(false, true){

                            @Override
                            protected void beforeCommit() throws Exception {
                                subscriber.notifyEvent(eventId, eventInfo);
                            }
                        }.execute();
                        continue block8;
                    }
                    case 3: {
                        new HibernateTxFragment(false, true){

                            @Override
                            protected void afterCommit() throws Exception {
                                subscriber.notifyEvent(eventId, eventInfo);
                            }
                        }.execute();
                        continue block8;
                    }
                    case 4: {
                        new HibernateTxFragment(false, true){

                            @Override
                            protected void afterCommit() throws Exception {
                                new Thread(new Runnable(){

                                    @Override
                                    public void run() {
                                        subscriber.notifyEvent(eventId, eventInfo);
                                    }
                                }).start();
                            }
                        }.execute();
                        continue block8;
                    }
                }
                throw new IllegalArgumentException("Subscriber notification mode not supported: " + subscriber.getTransactionContext());
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("Exception occurred when firing event: " + eventId, e);
            }
        }
    }
}

