/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database;

import java.sql.Connection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.jboss.dashboard.commons.security.password.PasswordObfuscator;
import org.jboss.dashboard.database.Persistent;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;

public abstract class DataSourceEntry
implements Persistent {
    private static transient Log log = LogFactory.getLog((String)DataSourceEntry.class.getName());
    private Long dbid;
    private String name;
    private String jndiPath;
    private String url;
    private String driverClass;
    private String obfuscatedUserName;
    private String obfuscatedPassword;
    private String testQuery;

    protected DataSourceEntry() {
    }

    public Long getDbid() {
        return this.dbid;
    }

    public void setDbid(Long dbid) {
        this.dbid = dbid;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getJndiPath() {
        return this.jndiPath;
    }

    public void setJndiPath(String jndiPath) {
        this.jndiPath = jndiPath;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return PasswordObfuscator.lookup().deobfuscate(this.obfuscatedPassword);
    }

    public void setPassword(String password) {
        this.obfuscatedPassword = PasswordObfuscator.lookup().obfuscate(password);
    }

    protected String getObfuscatedPassword() {
        return this.obfuscatedPassword;
    }

    protected void setObfuscatedPassword(String obfuscatedPassword) {
        this.obfuscatedPassword = obfuscatedPassword;
    }

    public String getTestQuery() {
        return this.testQuery;
    }

    public void setTestQuery(String testQuery) {
        this.testQuery = testQuery;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserName() {
        return PasswordObfuscator.lookup().deobfuscate(this.obfuscatedUserName);
    }

    public void setUserName(String userName) {
        this.obfuscatedUserName = PasswordObfuscator.lookup().obfuscate(userName);
    }

    protected String getObfuscatedUserName() {
        return this.obfuscatedUserName;
    }

    protected void setObfuscatedUserName(String obfuscatedUserName) {
        this.obfuscatedUserName = obfuscatedUserName;
    }

    public abstract Connection getConnection() throws Exception;

    @Override
    public boolean isPersistent() {
        return this.dbid != null;
    }

    @Override
    public void save() throws Exception {
        if (this.isPersistent()) {
            this.update();
        } else {
            this.saveOrUpdate();
        }
    }

    @Override
    public void update() throws Exception {
        if (!this.isPersistent()) {
            this.save();
        } else {
            this.saveOrUpdate();
        }
    }

    @Override
    public void delete() throws Exception {
        this.persist(2);
    }

    protected boolean saveOrUpdate() throws Exception {
        boolean isTransient;
        boolean bl = isTransient = !this.isPersistent();
        if (isTransient) {
            this.persist(0);
        } else {
            this.persist(1);
        }
        return isTransient;
    }

    protected void persist(final int op) throws Exception {
        new HibernateTxFragment(){

            @Override
            protected void txFragment(Session session) throws Exception {
                DataSourceEntry obj = DataSourceEntry.this;
                switch (op) {
                    case 0: {
                        session.save((Object)obj);
                        break;
                    }
                    case 1: {
                        session.update((Object)obj);
                        break;
                    }
                    case 2: {
                        session.delete((Object)obj);
                    }
                }
                session.flush();
            }
        }.execute();
    }
}

